/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.LibrariesNode;
import org.netbeans.modules.java.api.common.project.ui.ProjectUISupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

class J2eePlatformTestNode
extends AbstractNode
implements PropertyChangeListener,
InstanceListener {
    private static final String ARCHIVE_ICON = "org/netbeans/modules/j2ee/common/project/ui/resources/jar.gif";
    private static final String DEFAULT_ICON = "org/netbeans/modules/j2ee/common/project/ui/resources/j2eeServer.gif";
    private static final String BROKEN_PROJECT_BADGE = "org/netbeans/modules/j2ee/common/project/ui/resources/brokenProjectBadge.gif";
    private static final Icon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/j2ee/common/project/ui/resources/jar.gif", (boolean)false);
    private static final Image brokenIcon = ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/common/project/ui/resources/j2eeServer.gif"), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/common/project/ui/resources/brokenProjectBadge.gif"), (int)8, (int)0);
    private final PropertyEvaluator evaluator;
    private final String platformPropName;
    private J2eePlatform platformCache;
    private final PropertyChangeListener platformListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("displayName".equals(evt.getPropertyName())) {
                J2eePlatformTestNode.this.fireNameChange((String)evt.getOldValue(), (String)evt.getNewValue());
                J2eePlatformTestNode.this.fireDisplayNameChange((String)evt.getOldValue(), (String)evt.getNewValue());
            }
            if ("classpath".equals(evt.getPropertyName())) {
                J2eePlatformTestNode.this.postAddNotify();
            }
        }
    };
    private PropertyChangeListener weakPlatformListener;

    private J2eePlatformTestNode(Project project, PropertyEvaluator evaluator, String platformPropName, ClassPathSupport cs) {
        super((Children)new PlatformContentChildren(cs));
        this.evaluator = evaluator;
        this.platformPropName = platformPropName;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        moduleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this, (Object)moduleProvider));
    }

    public static J2eePlatformTestNode create(Project project, PropertyEvaluator evaluator, String platformPropName, ClassPathSupport cs) {
        return new J2eePlatformTestNode(project, evaluator, platformPropName, cs);
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return "";
    }

    public String getHtmlDisplayName() {
        if (this.getPlatform() != null) {
            return this.getPlatform().getDisplayName() + " (" + NbBundle.getMessage(J2eePlatformTestNode.class, (String)"LBL_J2eeServerEmbeddableContainer") + ")";
        }
        return NbBundle.getMessage(J2eePlatformTestNode.class, (String)"LBL_J2eeServerMissing");
    }

    public Image getIcon(int type) {
        Image result = null;
        if (this.getPlatform() != null) {
            result = this.getPlatform().getIcon();
        }
        return result != null ? result : brokenIcon;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[0];
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.platformPropName.equals(evt.getPropertyName())) {
            this.refresh();
        }
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (J2eePlatformTestNode.this.platformCache != null) {
                    J2eePlatformTestNode.this.platformCache.removePropertyChangeListener(J2eePlatformTestNode.this.weakPlatformListener);
                }
                J2eePlatformTestNode.this.platformCache = null;
                J2eePlatformTestNode.this.fireNameChange(null, null);
                J2eePlatformTestNode.this.fireDisplayNameChange(null, null);
                J2eePlatformTestNode.this.fireIconChange();
                J2eePlatformTestNode.this.postAddNotify();
            }
        });
    }

    public void instanceAdded(String serverInstanceID) {
        this.refresh();
    }

    public void instanceRemoved(String serverInstanceID) {
        this.refresh();
    }

    public void changeDefaultInstance(String oldServerInstanceID, String newServerInstanceID) {
    }

    private void postAddNotify() {
        LibrariesNode.rp.post(new Runnable(){

            @Override
            public void run() {
                ((PlatformContentChildren)J2eePlatformTestNode.this.getChildren()).addNotify();
            }
        });
    }

    private J2eePlatform getPlatform() {
        if (this.platformCache == null) {
            String j2eePlatformInstanceId = this.evaluator.getProperty(this.platformPropName);
            if (j2eePlatformInstanceId != null) {
                this.platformCache = Deployment.getDefault().getJ2eePlatform(j2eePlatformInstanceId);
            }
            if (this.platformCache != null) {
                this.weakPlatformListener = WeakListeners.propertyChange((PropertyChangeListener)this.platformListener, (Object)this.platformCache);
                this.platformCache.addPropertyChangeListener(this.weakPlatformListener);
                this.fireIconChange();
            }
        }
        return this.platformCache;
    }

    private static class PlatformContentChildren
    extends Children.Keys<SourceGroup> {
        PlatformContentChildren(ClassPathSupport cs) {
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(SourceGroup sg) {
            return new Node[]{ProjectUISupport.createFilteredLibrariesNode((Node)PackageView.createPackageView((SourceGroup)sg), null, null, null, null, null, null)};
        }

        private List<SourceGroup> getKeys() {
            List<SourceGroup> result;
            J2eePlatform j2eePlatform = ((J2eePlatformTestNode)this.getNode()).getPlatform();
            if (j2eePlatform != null && j2eePlatform.isToolSupported("embeddableejb")) {
                File[] classpathEntries = j2eePlatform.getToolClasspathEntries("embeddableejb");
                result = new ArrayList<SourceGroup>(classpathEntries.length);
                for (int i = 0; i < classpathEntries.length; ++i) {
                    FileObject archiveFile;
                    FileObject file = FileUtil.toFileObject((File)classpathEntries[i]);
                    if (file == null || (archiveFile = FileUtil.getArchiveRoot((FileObject)file)) == null) continue;
                    result.add(ProjectUISupport.createLibrariesSourceGroup((FileObject)archiveFile, (String)file.getNameExt(), (Icon)icon, (Icon)icon));
                }
            } else {
                result = Collections.emptyList();
            }
            return result;
        }
    }
}

