/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.MatchType;
import org.netbeans.modules.spring.java.Property;
import org.netbeans.modules.spring.java.PropertyFinder;
import org.openide.util.Exceptions;

public class PropertyHyperlinkProcessor
extends HyperlinkProcessor {
    @Override
    public void process(HyperlinkEnv env) {
        try {
            final String className = new BeanClassFinder(env.getBeanAttributes(), env.getFileObject()).findImplementationClass();
            if (className == null) {
                return;
            }
            final String propChain = this.getPropertyChainUptoPosition(env);
            if (propChain == null || propChain.equals("")) {
                return;
            }
            final boolean jumpToGetter = StringUtils.occurs(env.getValueString(), ".", propChain.length());
            JavaSource js = JavaUtils.getJavaSource(env.getFileObject());
            if (js == null) {
                return;
            }
            final int dotIndex = propChain.lastIndexOf(".");
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    if (className == null) {
                        return;
                    }
                    TypeElement te = JavaUtils.findClassElementByBinaryName(className, cc);
                    if (te == null) {
                        return;
                    }
                    TypeMirror startType = te.asType();
                    ElementUtilities eu = cc.getElementUtilities();
                    if (dotIndex != -1) {
                        String getterChain = propChain.substring(0, dotIndex);
                        StringTokenizer tokenizer = new StringTokenizer(getterChain, ".");
                        while (tokenizer.hasMoreTokens() && startType != null) {
                            String propertyName = tokenizer.nextToken();
                            Property[] props = new PropertyFinder(startType, propertyName, eu, MatchType.PREFIX).findProperties();
                            if (props.length == 0 || props[0].getGetter() == null) {
                                startType = null;
                                break;
                            }
                            TypeMirror retType = props[0].getGetter().getReturnType();
                            if (retType.getKind() == TypeKind.DECLARED) {
                                startType = retType;
                                continue;
                            }
                            startType = null;
                        }
                    }
                    if (startType == null) {
                        return;
                    }
                    String setterProp = propChain.substring(dotIndex + 1);
                    Property[] sProps = new PropertyFinder(startType, setterProp, eu, MatchType.PREFIX).findProperties();
                    if (sProps.length > 0) {
                        ExecutableElement element;
                        ExecutableElement executableElement = element = jumpToGetter ? sProps[0].getGetter() : sProps[0].getSetter();
                        if (element != null) {
                            ElementOpen.open((ClasspathInfo)cc.getClasspathInfo(), (Element)element);
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public int[] getSpan(HyperlinkEnv env) {
        int addOffset = env.getTokenStartOffset() + 1;
        String propChain = this.getPropertyChainUptoPosition(env);
        if (propChain == null || propChain.equals("")) {
            return null;
        }
        int endPos = env.getTokenStartOffset() + propChain.length() + 1;
        int startPos = propChain.lastIndexOf(".");
        startPos = startPos == -1 ? 0 : ++startPos;
        return new int[]{startPos += addOffset, endPos};
    }

    private String getPropertyChainUptoPosition(HyperlinkEnv env) {
        int relOffset = env.getOffset() - env.getTokenStartOffset() - 1;
        int endPos = env.getValueString().indexOf(".", relOffset);
        if (endPos == -1) {
            return env.getValueString();
        }
        return env.getValueString().substring(0, endPos);
    }
}

