/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring.plugins;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.beans.refactoring.ModificationTransaction;
import org.netbeans.modules.spring.beans.refactoring.Modifications;
import org.netbeans.modules.spring.beans.refactoring.Occurrences;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactoringElement;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactorings;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

class SpringMovePlugin
implements RefactoringPlugin {
    private final MoveRefactoring refactoring;

    public SpringMovePlugin(MoveRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        try {
            SpringScope scope;
            URL target = (URL)this.refactoring.getTarget().lookup(URL.class);
            if (target == null) {
                return null;
            }
            String targetPackageName = SpringRefactorings.getPackageName(target);
            if (targetPackageName == null) {
                return null;
            }
            HashMap<SpringScope, ArrayList<String>> scope2PackageNames = new HashMap<SpringScope, ArrayList<String>>();
            HashMap<SpringScope, ArrayList<String>> scope2ClassNames = new HashMap<SpringScope, ArrayList<String>>();
            for (FileObject fo : this.refactoring.getRefactoringSource().lookupAll(FileObject.class)) {
                SpringScope scope2;
                if (fo.isFolder()) {
                    String oldPackageName = SpringRefactorings.getPackageName(fo);
                    if (oldPackageName == null || (scope = SpringScope.getSpringScope(fo)) == null) continue;
                    ArrayList<String> packageNames = (ArrayList<String>)scope2PackageNames.get(scope);
                    if (packageNames == null) {
                        packageNames = new ArrayList<String>();
                        scope2PackageNames.put(scope, packageNames);
                    }
                    packageNames.add(oldPackageName);
                    continue;
                }
                if (!SpringRefactorings.isJavaFile(fo) || (scope2 = SpringScope.getSpringScope(fo)) == null) continue;
                ArrayList<String> classNames = (ArrayList<String>)scope2ClassNames.get(scope2);
                if (classNames == null) {
                    classNames = new ArrayList<String>();
                    scope2ClassNames.put(scope2, classNames);
                }
                classNames.addAll(SpringRefactorings.getTopLevelClassNames(fo));
            }
            Modifications mods = new Modifications();
            for (Map.Entry entry : scope2PackageNames.entrySet()) {
                scope = (SpringScope)entry.getKey();
                for (String packageName : (List)entry.getValue()) {
                    String simplePackageName;
                    String newPackageName = SpringRefactorings.createQualifiedName(packageName, simplePackageName = SpringRefactorings.getSimpleElementName(packageName));
                    if (newPackageName == null) continue;
                    for (Occurrences.Occurrence occurrence : Occurrences.getJavaPackageOccurrences(packageName, true, scope)) {
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)SpringRefactoringElement.createJavaElementRefModification(occurrence, mods, null, newPackageName));
                    }
                }
            }
            for (Map.Entry entry : scope2ClassNames.entrySet()) {
                scope = (SpringScope)entry.getKey();
                for (String className : (List)entry.getValue()) {
                    String simpleClassName = SpringRefactorings.getSimpleElementName(className);
                    String newClassName = SpringRefactorings.createQualifiedName(targetPackageName, simpleClassName);
                    if (newClassName == null) continue;
                    for (Occurrences.Occurrence occurrence : Occurrences.getJavaClassOccurrences(className, scope)) {
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)SpringRefactoringElement.createJavaElementRefModification(occurrence, mods, null, newClassName));
                    }
                }
            }
            refactoringElements.registerTransaction((Transaction)new ModificationTransaction(mods));
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }
}

