/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.java;

import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.MatchType;
import org.netbeans.modules.spring.java.Property;

public class PropertyFinder {
    private final ElementUtilities eu;
    private final TypeMirror type;
    private final String matchText;
    private final Map<String, Property> name2Prop = new HashMap<String, Property>();
    private final MatchType matchType;

    public PropertyFinder(TypeMirror type, String matchText, ElementUtilities eu, MatchType matchType) {
        this.type = type;
        this.matchText = matchText;
        this.eu = eu;
        this.matchType = matchType;
    }

    public Property[] findProperties() {
        this.name2Prop.clear();
        this.eu.getMembers(this.type, new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror type) {
                if (e.getKind() != ElementKind.METHOD) {
                    return false;
                }
                ExecutableElement ee = (ExecutableElement)e;
                String methodName = ee.getSimpleName().toString();
                if (JavaUtils.isGetter(ee)) {
                    String propName = JavaUtils.getPropertyName(methodName);
                    if (!PropertyFinder.this.match(propName)) {
                        return false;
                    }
                    PropertyFinder.this.addPropertyGetter(propName, ee);
                    return true;
                }
                if (JavaUtils.isSetter(ee)) {
                    String propName = JavaUtils.getPropertyName(methodName);
                    if (!PropertyFinder.this.match(propName)) {
                        return false;
                    }
                    PropertyFinder.this.addPropertySetter(propName, ee);
                    return true;
                }
                return false;
            }
        });
        return this.name2Prop.values().toArray(new Property[0]);
    }

    private void addPropertySetter(String propName, ExecutableElement setter) {
        Property prop = this.getProperty(propName);
        prop.setSetter(setter);
    }

    private void addPropertyGetter(String propName, ExecutableElement getter) {
        Property prop = this.getProperty(propName);
        prop.setGetter(getter);
    }

    private Property getProperty(String propName) {
        Property prop = this.name2Prop.get(propName);
        if (prop == null) {
            prop = new Property(propName);
            this.name2Prop.put(propName, prop);
        }
        return prop;
    }

    private boolean match(String propName) {
        int length = this.matchType == MatchType.PREFIX ? this.matchText.length() : Math.max(propName.length(), this.matchText.length());
        return propName.regionMatches(0, this.matchText, 0, length);
    }
}

