/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.graph.layout;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayoutListener;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;

public abstract class GraphLayout<N, E> {
    private boolean animated = true;
    private final ArrayList<GraphLayoutListener<N, E>> listeners = new ArrayList();

    public final boolean isAnimated() {
        return this.animated;
    }

    public final void setAnimated(boolean animated) {
        this.animated = animated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGraphLayoutListener(GraphLayoutListener<N, E> listener) {
        ArrayList<GraphLayoutListener<N, E>> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeGraphLayoutListener(GraphLayoutListener<N, E> listener) {
        ArrayList<GraphLayoutListener<N, E>> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    public final void layoutGraph(GraphScene<N, E> graphScene) {
        GraphLayoutListener<N, E>[] listeners = this.createListenersCopy();
        UniversalGraph<N, E> graph = UniversalGraph.createUniversalGraph(graphScene);
        for (GraphLayoutListener<N, E> listener : listeners) {
            listener.graphLayoutStarted(graph);
        }
        this.performGraphLayout(graph);
        for (GraphLayoutListener<N, E> listener : listeners) {
            listener.graphLayoutFinished(graph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <N, E> GraphLayoutListener<N, E>[] createListenersCopy() {
        GraphLayoutListener[] listeners;
        ArrayList<GraphLayoutListener<N, E>> arrayList = this.listeners;
        synchronized (arrayList) {
            listeners = this.listeners.toArray(new GraphLayoutListener[this.listeners.size()]);
        }
        return listeners;
    }

    public final void layoutGraph(GraphPinScene<N, E, ?> graphPinScene) {
        GraphLayoutListener<N, E>[] listeners = this.createListenersCopy();
        UniversalGraph<N, E> graph = UniversalGraph.createUniversalGraph(graphPinScene);
        for (GraphLayoutListener<N, E> listener : listeners) {
            listener.graphLayoutStarted(graph);
        }
        this.performGraphLayout(graph);
        for (GraphLayoutListener<N, E> listener : listeners) {
            listener.graphLayoutFinished(graph);
        }
    }

    public final void layoutNodes(GraphScene<N, E> graphScene, Collection<N> nodes) {
        GraphLayoutListener<N, E>[] listeners = this.createListenersCopy();
        UniversalGraph<N, E> graph = UniversalGraph.createUniversalGraph(graphScene);
        for (GraphLayoutListener<N, E> listener : listeners) {
            listener.graphLayoutStarted(graph);
        }
        this.performNodesLayout(graph, nodes);
        for (GraphLayoutListener<N, E> listener : listeners) {
            listener.graphLayoutFinished(graph);
        }
    }

    public final void layoutNodes(GraphPinScene<N, E, ?> graphPinScene, Collection<N> nodes) {
        GraphLayoutListener<N, E>[] listeners = this.createListenersCopy();
        UniversalGraph<N, E> graph = UniversalGraph.createUniversalGraph(graphPinScene);
        for (GraphLayoutListener<N, E> listener : listeners) {
            listener.graphLayoutStarted(graph);
        }
        this.performNodesLayout(graph, nodes);
        for (GraphLayoutListener<N, E> listener : listeners) {
            listener.graphLayoutFinished(graph);
        }
    }

    protected final void setResolvedNodeLocation(UniversalGraph<N, E> graph, N node, Point newPreferredLocation) {
        GraphLayoutListener<N, E>[] listeners;
        ObjectScene scene = graph.getScene();
        Widget widget = scene.findWidget(node);
        if (widget == null) {
            return;
        }
        Point previousPreferredLocation = widget.getPreferredLocation();
        if (this.animated) {
            scene.getSceneAnimator().animatePreferredLocation(widget, newPreferredLocation);
        } else {
            widget.setPreferredLocation(newPreferredLocation);
        }
        for (GraphLayoutListener<N, E> listener : listeners = this.createListenersCopy()) {
            listener.nodeLocationChanged(graph, node, previousPreferredLocation, newPreferredLocation);
        }
    }

    protected abstract void performGraphLayout(UniversalGraph<N, E> var1);

    protected abstract void performNodesLayout(UniversalGraph<N, E> var1, Collection<N> var2);
}

