/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.awt.Image;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.model.wadl.Resource;
import org.netbeans.modules.websvc.saas.ui.nodes.ResourceNodeChildren;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ResourceNode
extends AbstractNode {
    private final WadlSaasResource resource;
    private static final Image SERVICE_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/saas/ui/resources/restservice.png");

    public ResourceNode(WadlSaasResource resource) {
        this(resource, new InstanceContent());
    }

    protected ResourceNode(WadlSaasResource resource, InstanceContent content) {
        super((Children)new ResourceNodeChildren(resource), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.resource = resource;
        content.add((Object)resource);
    }

    public Resource getResource() {
        return this.resource.getResource();
    }

    public String getDisplayName() {
        return "[" + this.getResource().getPath() + "]";
    }

    public String getShortDescription() {
        StringBuffer sb = new StringBuffer();
        for (WadlSaasResource r = this.resource; r != null; r = r.getParent()) {
            sb.insert(0, '/');
            sb.insert(0, r.getResource().getPath());
        }
        sb.insert(0, '/');
        sb.insert(0, this.resource.getSaas().getBaseURL());
        return sb.toString();
    }

    public Image getIcon(int type) {
        return SERVICE_BADGE;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action[] getActions(boolean context) {
        List<Action> actions = SaasNode.getActions(this.getLookup());
        return actions.toArray(new Action[actions.size()]);
    }
}

