/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.modules.java.editor.codegen.ui.ImplementOverridePanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ImplementOverrideMethodGenerator
implements CodeGenerator {
    private JTextComponent component;
    private ElementNode.Description description;
    private boolean isImplement;

    private ImplementOverrideMethodGenerator(JTextComponent component, ElementNode.Description description, boolean isImplement) {
        this.component = component;
        this.description = description;
        this.isImplement = isImplement;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ImplementOverrideMethodGenerator.class, (String)(this.isImplement ? "LBL_implement_method" : "LBL_override_method"));
    }

    public void invoke() {
        JavaSource js;
        final ImplementOverridePanel panel = new ImplementOverridePanel(this.description, this.isImplement);
        final int caretOffset = this.component.getCaretPosition();
        DialogDescriptor dialogDescriptor = GeneratorUtils.createDialogDescriptor(panel, NbBundle.getMessage(ConstructorGenerator.class, (String)(this.isImplement ? "LBL_generate_implement" : "LBL_generate_override")));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == dialogDescriptor.getDefaultValue() && (js = JavaSource.forDocument((Document)this.component.getDocument())) != null) {
            try {
                ModificationResult mr = js.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy copy) throws IOException {
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath path = copy.getTreeUtilities().pathFor(caretOffset);
                        path = Utilities.getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path);
                        if (path == null) {
                            return;
                        }
                        int idx = GeneratorUtils.findClassMemberIndex(copy, (ClassTree)path.getLeaf(), caretOffset);
                        ArrayList<ExecutableElement> methodElements = new ArrayList<ExecutableElement>();
                        for (ElementHandle<? extends Element> elementHandle : panel.getSelectedMethods()) {
                            methodElements.add((ExecutableElement)elementHandle.resolve((CompilationInfo)copy));
                        }
                        if (ImplementOverrideMethodGenerator.this.isImplement) {
                            GeneratorUtils.generateAbstractMethodImplementations(copy, path, methodElements, idx);
                        } else {
                            GeneratorUtils.generateMethodOverrides(copy, path, methodElements, idx);
                        }
                    }
                });
                GeneratorUtils.guardedCommit(this.component, mr);
                int[] span = mr.getSpan((Object)"methodBodyTag");
                if (span != null) {
                    this.component.setSelectionStart(span[0]);
                    this.component.setSelectionEnd(span[1]);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<ImplementOverrideMethodGenerator> ret = new ArrayList<ImplementOverrideMethodGenerator>();
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CompilationController controller = (CompilationController)context.lookup(CompilationController.class);
            TreePath path = (TreePath)context.lookup(TreePath.class);
            TreePath treePath = path = path != null ? Utilities.getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path) : null;
            if (component == null || controller == null || path == null) {
                return ret;
            }
            try {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            }
            catch (IOException ioe) {
                return ret;
            }
            TypeElement typeElement = (TypeElement)controller.getTrees().getElement(path);
            if (typeElement == null || !typeElement.getKind().isClass()) {
                return ret;
            }
            LinkedHashMap<Element, ArrayList<ElementNode.Description>> map = new LinkedHashMap<Element, ArrayList<ElementNode.Description>>();
            for (ExecutableElement executableElement : GeneratorUtils.findUndefs((CompilationInfo)controller, typeElement)) {
                ArrayList<ElementNode.Description> descriptions = (ArrayList<ElementNode.Description>)map.get(executableElement.getEnclosingElement());
                if (descriptions == null) {
                    descriptions = new ArrayList<ElementNode.Description>();
                    map.put(executableElement.getEnclosingElement(), descriptions);
                }
                descriptions.add(ElementNode.Description.create((CompilationInfo)controller, executableElement, null, true, false));
            }
            ArrayList<ElementNode.Description> implementDescriptions = new ArrayList<ElementNode.Description>();
            for (Map.Entry entry : map.entrySet()) {
                implementDescriptions.add(ElementNode.Description.create((CompilationInfo)controller, (Element)entry.getKey(), (List)entry.getValue(), false, false));
            }
            if (!implementDescriptions.isEmpty()) {
                ret.add(new ImplementOverrideMethodGenerator(component, ElementNode.Description.create(implementDescriptions), true));
            }
            map = new LinkedHashMap();
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (ExecutableElement executableElement : GeneratorUtils.findOverridable((CompilationInfo)controller, typeElement)) {
                ArrayList<ElementNode.Description> descriptions = (ArrayList<ElementNode.Description>)map.get(executableElement.getEnclosingElement());
                if (descriptions == null) {
                    descriptions = new ArrayList<ElementNode.Description>();
                    Element e = executableElement.getEnclosingElement();
                    map.put(e, descriptions);
                    if (!arrayList.contains(e)) {
                        arrayList.add(e);
                    }
                }
                descriptions.add(ElementNode.Description.create((CompilationInfo)controller, executableElement, null, true, false));
            }
            ArrayList<ElementNode.Description> overrideDescriptions = new ArrayList<ElementNode.Description>();
            for (Element e : arrayList) {
                overrideDescriptions.add(ElementNode.Description.create((CompilationInfo)controller, e, (List)map.get(e), false, false));
            }
            if (!overrideDescriptions.isEmpty()) {
                ret.add(new ImplementOverrideMethodGenerator(component, ElementNode.Description.create(overrideDescriptions), false));
            }
            return ret;
        }
    }
}

