/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.maven.index.AbstractSearchRequest;
import org.apache.maven.index.AbstractSearchResponse;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoGroup;
import org.apache.maven.index.DefaultIteratorResultSet;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.GroupedSearchRequest;
import org.apache.maven.index.GroupedSearchResponse;
import org.apache.maven.index.Grouping;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.SearchEngine;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.NexusIndexSearcher;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=SearchEngine.class)
public class DefaultSearchEngine
extends AbstractLogEnabled
implements SearchEngine {
    @Override
    @Deprecated
    public Set<ArtifactInfo> searchFlat(Comparator<ArtifactInfo> artifactInfoComparator, IndexingContext indexingContext, Query query) throws IOException {
        return this.searchFlatPaged(new FlatSearchRequest(query, artifactInfoComparator, indexingContext)).getResults();
    }

    @Override
    @Deprecated
    public Set<ArtifactInfo> searchFlat(Comparator<ArtifactInfo> artifactInfoComparator, Collection<IndexingContext> indexingContexts, Query query) throws IOException {
        return this.searchFlatPaged(new FlatSearchRequest(query, artifactInfoComparator), indexingContexts).getResults();
    }

    public FlatSearchResponse searchFlatPaged(FlatSearchRequest request) throws IOException {
        TreeSet<ArtifactInfo> result = new TreeSet<ArtifactInfo>(request.getArtifactInfoComparator());
        int totalHits = 0;
        for (IndexingContext context : request.getContexts()) {
            totalHits += this.searchFlat(request, result, context, request.getQuery(), request.getStart(), request.getCount());
        }
        return new FlatSearchResponse(request.getQuery(), totalHits, result);
    }

    @Override
    public FlatSearchResponse searchFlatPaged(FlatSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        return this.searchFlatPaged(request, indexingContexts, false);
    }

    @Override
    public FlatSearchResponse forceSearchFlatPaged(FlatSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        return this.searchFlatPaged(request, indexingContexts, true);
    }

    private FlatSearchResponse searchFlatPaged(FlatSearchRequest request, Collection<IndexingContext> indexingContexts, boolean ignoreContext) throws IOException {
        TreeSet<ArtifactInfo> result = new TreeSet<ArtifactInfo>(request.getArtifactInfoComparator());
        int totalHits = 0;
        for (IndexingContext ctx : indexingContexts) {
            if (ignoreContext || ctx.isSearchable()) {
                int hitCount = this.searchFlat(request, result, ctx, request.getQuery(), request.getStart(), request.getCount());
                totalHits = hitCount == AbstractSearchResponse.LIMIT_EXCEEDED ? hitCount : (totalHits += hitCount);
            }
            if ((!request.isHitLimited() || totalHits <= request.getResultHitLimit()) && totalHits != AbstractSearchResponse.LIMIT_EXCEEDED) continue;
            totalHits = AbstractSearchResponse.LIMIT_EXCEEDED;
            result = new TreeSet<ArtifactInfo>(request.getArtifactInfoComparator());
            break;
        }
        return new FlatSearchResponse(request.getQuery(), totalHits, result);
    }

    @Override
    public GroupedSearchResponse searchGrouped(GroupedSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        return this.searchGrouped(request, indexingContexts, false);
    }

    @Override
    public GroupedSearchResponse forceSearchGrouped(GroupedSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        return this.searchGrouped(request, indexingContexts, true);
    }

    protected GroupedSearchResponse searchGrouped(GroupedSearchRequest request, Collection<IndexingContext> indexingContexts, boolean ignoreContext) throws IOException {
        TreeMap<String, ArtifactInfoGroup> result = new TreeMap<String, ArtifactInfoGroup>(request.getGroupKeyComparator());
        int totalHits = 0;
        for (IndexingContext ctx : indexingContexts) {
            if (ignoreContext || ctx.isSearchable()) {
                int hitCount = this.searchGrouped(request, result, request.getGrouping(), ctx, request.getQuery());
                totalHits = hitCount == AbstractSearchResponse.LIMIT_EXCEEDED ? hitCount : (totalHits += hitCount);
            }
            if ((!request.isHitLimited() || totalHits <= request.getResultHitLimit()) && totalHits != AbstractSearchResponse.LIMIT_EXCEEDED) continue;
            totalHits = AbstractSearchResponse.LIMIT_EXCEEDED;
            result = new TreeMap(request.getGroupKeyComparator());
            break;
        }
        return new GroupedSearchResponse(request.getQuery(), totalHits, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int searchFlat(AbstractSearchRequest req, Collection<ArtifactInfo> result, IndexingContext context, Query query, int from, int aiCount) throws IOException {
        context.lock();
        try {
            int start;
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)req.getResultHitLimit(), (boolean)true);
            context.getIndexSearcher().search(query, (Collector)collector);
            if (collector.getTotalHits() == 0) {
                int n = 0;
                return n;
            }
            if (req.isHitLimited() && collector.getTotalHits() > req.getResultHitLimit()) {
                int n = AbstractSearchResponse.LIMIT_EXCEEDED;
                return n;
            }
            ScoreDoc[] scoreDocs = collector.topDocs().scoreDocs;
            int hitCount = scoreDocs.length;
            for (int i = start = 0; i < scoreDocs.length; ++i) {
                Document doc = context.getIndexSearcher().doc(scoreDocs[i].doc);
                ArtifactInfo artifactInfo = IndexUtils.constructArtifactInfo(doc, context);
                if (artifactInfo == null) continue;
                artifactInfo.repository = context.getRepositoryId();
                artifactInfo.context = context.getId();
                result.add(artifactInfo);
                if (!req.isHitLimited() || result.size() <= req.getResultHitLimit()) continue;
                int n = AbstractSearchResponse.LIMIT_EXCEEDED;
                return n;
            }
            int n = hitCount;
            return n;
        }
        finally {
            context.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int searchGrouped(AbstractSearchRequest req, Map<String, ArtifactInfoGroup> result, Grouping grouping, IndexingContext context, Query query) throws IOException {
        context.lock();
        try {
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)req.getResultHitLimit(), (boolean)true);
            context.getIndexSearcher().search(query, (Collector)collector);
            if (collector.getTotalHits() > 0) {
                if (req.isHitLimited() && collector.getTotalHits() > req.getResultHitLimit()) {
                    int n = AbstractSearchResponse.LIMIT_EXCEEDED;
                    return n;
                }
                ScoreDoc[] scoreDocs = collector.topDocs().scoreDocs;
                int hitCount = scoreDocs.length;
                for (int i = 0; i < scoreDocs.length; ++i) {
                    Document doc = context.getIndexSearcher().doc(scoreDocs[i].doc);
                    ArtifactInfo artifactInfo = IndexUtils.constructArtifactInfo(doc, context);
                    if (artifactInfo == null) continue;
                    artifactInfo.repository = context.getRepositoryId();
                    artifactInfo.context = context.getId();
                    if (grouping.addArtifactInfo(result, artifactInfo)) continue;
                    --hitCount;
                }
                int n = hitCount;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            context.unlock();
        }
    }

    @Override
    public IteratorSearchResponse searchIteratorPaged(IteratorSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        return this.searchIteratorPaged(request, indexingContexts, false);
    }

    @Override
    public IteratorSearchResponse forceSearchIteratorPaged(IteratorSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        return this.searchIteratorPaged(request, indexingContexts, true);
    }

    private IteratorSearchResponse searchIteratorPaged(IteratorSearchRequest request, Collection<IndexingContext> indexingContexts, boolean ignoreContext) throws IOException {
        if (request.getStart() < 0) {
            request.setStart(-1);
        }
        if (request.getCount() < 0) {
            request.setCount(-1);
        }
        try {
            ArrayList<IndexingContext> contexts = new ArrayList<IndexingContext>(indexingContexts.size());
            for (IndexingContext ctx : indexingContexts) {
                if (!ignoreContext && !ctx.isSearchable()) continue;
                contexts.add(ctx);
                ctx.lock();
            }
            ArrayList<IndexReader> contextsToSearch = new ArrayList<IndexReader>(contexts.size());
            for (IndexingContext ctx : contexts) {
                contextsToSearch.add(ctx.getIndexReader());
            }
            MultiReader multiReader = new MultiReader(contextsToSearch.toArray(new IndexReader[contextsToSearch.size()]));
            NexusIndexSearcher indexSearcher = new NexusIndexSearcher((IndexReader)multiReader);
            TopScoreDocCollector hits = TopScoreDocCollector.create((int)request.getResultHitLimit(), (boolean)true);
            indexSearcher.search(request.getQuery(), (Collector)hits);
            return new IteratorSearchResponse(request.getQuery(), hits.getTotalHits(), new DefaultIteratorResultSet(request, indexSearcher, contexts, hits.topDocs()));
        }
        catch (Throwable e) {
            for (IndexingContext ctx : indexingContexts) {
                if (!ignoreContext && !ctx.isSearchable()) continue;
                ctx.unlock();
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }
}

