/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.customizer;

import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.JCProjectProperties;
import org.netbeans.modules.javacard.project.customizer.AppletCustomizer;
import org.netbeans.modules.javacard.project.customizer.AppletProjectCustomizerRun;
import org.netbeans.modules.javacard.project.customizer.AppletProjectProperties;
import org.netbeans.modules.javacard.project.customizer.ClassicAppletProjectProperties;
import org.netbeans.modules.javacard.project.customizer.CompilingPanel;
import org.netbeans.modules.javacard.project.customizer.CustomizerIDs;
import org.netbeans.modules.javacard.project.customizer.CustomizerSources;
import org.netbeans.modules.javacard.project.customizer.PackagingCustomizer;
import org.netbeans.modules.javacard.project.customizer.RunCustomizer;
import org.netbeans.modules.javacard.project.customizer.SecurityCustomizer;
import org.netbeans.modules.javacard.project.customizer.WebCustomizer;
import org.netbeans.modules.javacard.project.customizer.WebProjectCustomizerRun;
import org.netbeans.modules.javacard.project.customizer.WebProjectProperties;
import org.netbeans.modules.javacard.project.deps.ui.DependenciesPanel;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationGroupProvider;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class JCProjectCategoryProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private final CustomizerIDs id;

    private JCProjectCategoryProvider(CustomizerIDs id) {
        this.id = id;
    }

    public ProjectCustomizer.Category createCategory(Lookup context) {
        return ProjectCustomizer.Category.create((String)this.id.name(), (String)this.id.getDisplayName(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        JPanel result;
        JCProjectProperties uiProps = (JCProjectProperties)context.lookup(JCProjectProperties.class);
        JCProject p = (JCProject)context.lookup(JCProject.class);
        ProjectKind kind = p.kind();
        block0 : switch (this.id) {
            case CUSTOMIZER_ID_DEPENDENCIES: {
                result = new DependenciesPanel(uiProps);
                break;
            }
            case CUSTOMIZER_ID_COMPILING: {
                result = new CompilingPanel(uiProps);
                break;
            }
            case CUSTOMIZER_ID_APPLET: {
                result = new AppletCustomizer((AppletProjectProperties)uiProps, category);
                break;
            }
            case CUSTOMIZER_ID_PACKAGING: {
                result = new PackagingCustomizer((ClassicAppletProjectProperties)uiProps, category);
                break;
            }
            case CUSTOMIZER_ID_RUN: {
                switch (kind) {
                    case CLASSIC_APPLET: 
                    case EXTENDED_APPLET: {
                        result = new AppletProjectCustomizerRun((AppletProjectProperties)uiProps);
                        break block0;
                    }
                    case WEB: {
                        result = new WebProjectCustomizerRun((WebProjectProperties)uiProps);
                        break block0;
                    }
                    case EXTENSION_LIBRARY: 
                    case CLASSIC_LIBRARY: {
                        result = new RunCustomizer(uiProps);
                        break block0;
                    }
                }
                throw new AssertionError();
            }
            case CUSTOMIZER_ID_SECURITY: {
                result = new SecurityCustomizer(uiProps, category);
                break;
            }
            case CUSTOMIZER_ID_SOURCES: {
                result = new CustomizerSources(uiProps);
                break;
            }
            case CUSTOMIZER_ID_WEB: {
                result = new WebCustomizer((WebProjectProperties)uiProps, category);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (result instanceof ValidationGroupProvider) {
            ValidationGroup vg = ((ValidationGroupProvider)result).getValidationGroup();
            vg.addUI((ValidationUI)new CategoryValidationUI(category));
        }
        return result;
    }

    public static JCProjectCategoryProvider create(FileObject fo) {
        CustomizerIDs id = CustomizerIDs.forFileName(fo.getName());
        return new JCProjectCategoryProvider(id);
    }

    private static final class CategoryValidationUI
    implements ValidationUI {
        private final ProjectCustomizer.Category category;

        public CategoryValidationUI(ProjectCustomizer.Category category) {
            this.category = category;
        }

        public void clearProblem() {
            this.category.setValid(true);
            this.category.setErrorMessage(null);
        }

        public void setProblem(Problem prblm) {
            this.category.setValid(prblm.isFatal());
            this.category.setErrorMessage(prblm.getMessage());
        }
    }
}

