/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders;

import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.glassfish.eecommon.api.config.J2EEBaseVersion;
import org.netbeans.modules.glassfish.eecommon.api.config.J2EEVersion;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.ddloaders.DDType;
import org.netbeans.modules.j2ee.sun.ddloaders.SunDescriptorDataObject;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.appclient.SunAppClientOverviewMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.common.EnvironmentMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.common.SecurityRoleMappingMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.ejb.EjbMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.ejb.SunEjbOverviewMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.jms.JmsMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.web.ServletMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.web.SunWebOverviewMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.webservice.WebServiceMultiViewElement;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class DDViewFactory
implements Serializable {
    private static final long serialVersionUID = -8759598009819101743L;
    public static final String OVERVIEW = "Overview";
    public static final String SERVLET = "Servlet";
    public static final String EJB = "EJB";
    public static final String SECURITY = "Security";
    public static final String WSSERVICE = "WSService";
    public static final String JMS = "JMS";
    public static final String ENVIRONMENT = "Environment";
    private static transient Map<DDType, DDViewFactory> factoryMap = new HashMap<DDType, DDViewFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDViewFactory getViewFactory(DDType type) {
        DDViewFactory factory = null;
        Map<DDType, DDViewFactory> map = factoryMap;
        synchronized (map) {
            factory = factoryMap.get(type);
            if (factory == null) {
                factory = type.createViewFactory();
                factoryMap.put(type, factory);
            }
        }
        return factory;
    }

    public abstract DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject var1);

    public MultiViewElement createElement(SunDescriptorDataObject dataObject, String name) {
        if (name.equals(SECURITY)) {
            return new SecurityRoleMappingMultiViewElement(dataObject);
        }
        if (name.equals(ENVIRONMENT)) {
            return new EnvironmentMultiViewElement(dataObject);
        }
        if (name.equals(WSSERVICE)) {
            return new WebServiceMultiViewElement(dataObject);
        }
        if (name.equals(JMS)) {
            return new JmsMultiViewElement(dataObject);
        }
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    class DDView
    extends DesignMultiViewDesc
    implements Serializable {
        private static final long serialVersionUID = -8759598009819101741L;
        private String name;

        DDView(SunDescriptorDataObject dataObject, String name) {
            super((XmlMultiViewDataObject)dataObject, name);
            this.name = name;
        }

        public MultiViewElement createElement() {
            SunDescriptorDataObject dataObject = (SunDescriptorDataObject)this.getDataObject();
            return DDViewFactory.this.createElement(dataObject, this.name);
        }

        public HelpCtx getHelpCtx() {
            SunDescriptorDataObject dataObject = (SunDescriptorDataObject)this.getDataObject();
            return new HelpCtx(dataObject.getActiveMVElement().getSectionView().getClass());
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/resources/DDValidIcon.gif");
        }

        public String preferredID() {
            return "sundd_multiview_" + this.name;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DDViewFactory.class, (String)("LBL_" + this.name));
        }
    }

    public static class SunResourceDDViewFactory
    extends DDViewFactory {
        private static final long serialVersionUID = -8759598009819101753L;

        @Override
        public DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject dataObject) {
            return new DDView[0];
        }

        @Override
        public MultiViewElement createElement(SunDescriptorDataObject dataObject, String name) {
            return super.createElement(dataObject, name);
        }
    }

    public static class SunCmpMappingsDDViewFactory
    extends DDViewFactory {
        private static final long serialVersionUID = -8759598009819101753L;

        @Override
        public DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject dataObject) {
            return new DDView[0];
        }

        @Override
        public MultiViewElement createElement(SunDescriptorDataObject dataObject, String name) {
            return super.createElement(dataObject, name);
        }
    }

    public static class SunAppClientDDViewFactory
    extends DDViewFactory {
        private static final long serialVersionUID = -8759598009819101751L;

        @Override
        public DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject dataObject) {
            J2EEBaseVersion j2eeVersion;
            ASDDVersion asDDVersion = dataObject.getASDDVersion();
            ArrayList<DDView> views = new ArrayList<DDView>();
            if (ASDDVersion.SUN_APPSERVER_9_0.compareTo((Object)asDDVersion) <= 0) {
                views.add(new DDView(dataObject, DDViewFactory.OVERVIEW));
            }
            views.add(new DDView(dataObject, DDViewFactory.ENVIRONMENT));
            if (ASDDVersion.SUN_APPSERVER_8_0.compareTo((Object)asDDVersion) <= 0 && ((j2eeVersion = dataObject.getJ2eeModuleVersion()) == null || j2eeVersion.compareSpecification((J2EEBaseVersion)J2EEVersion.J2EE_1_4) >= 0)) {
                views.add(new DDView(dataObject, DDViewFactory.WSSERVICE));
                views.add(new DDView(dataObject, DDViewFactory.JMS));
            }
            return views.toArray(new DDView[views.size()]);
        }

        @Override
        public MultiViewElement createElement(SunDescriptorDataObject dataObject, String name) {
            if (name.equals(DDViewFactory.OVERVIEW)) {
                return new SunAppClientOverviewMultiViewElement(dataObject);
            }
            return super.createElement(dataObject, name);
        }
    }

    public static class SunApplicationDDViewFactory
    extends DDViewFactory {
        private static final long serialVersionUID = -8759598009819101749L;

        @Override
        public DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject dataObject) {
            return new DDView[]{new DDView(dataObject, DDViewFactory.SECURITY)};
        }

        @Override
        public MultiViewElement createElement(SunDescriptorDataObject dataObject, String name) {
            return super.createElement(dataObject, name);
        }
    }

    public static class SunEjbJarDDViewFactory
    extends DDViewFactory {
        private static final long serialVersionUID = -8759598009819101747L;

        @Override
        public DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject dataObject) {
            J2EEBaseVersion j2eeVersion;
            ASDDVersion asDDVersion = dataObject.getASDDVersion();
            ArrayList<DDView> views = new ArrayList<DDView>(6);
            views.add(new DDView(dataObject, DDViewFactory.OVERVIEW));
            views.add(new DDView(dataObject, DDViewFactory.EJB));
            views.add(new DDView(dataObject, DDViewFactory.SECURITY));
            if (ASDDVersion.SUN_APPSERVER_8_0.compareTo((Object)asDDVersion) <= 0 && ((j2eeVersion = dataObject.getJ2eeModuleVersion()) == null || j2eeVersion.compareSpecification((J2EEBaseVersion)J2EEVersion.J2EE_1_4) >= 0)) {
                views.add(new DDView(dataObject, DDViewFactory.WSSERVICE));
                views.add(new DDView(dataObject, DDViewFactory.JMS));
            }
            return views.toArray(new DDView[views.size()]);
        }

        @Override
        public MultiViewElement createElement(SunDescriptorDataObject dataObject, String name) {
            if (name.equals(DDViewFactory.OVERVIEW)) {
                return new SunEjbOverviewMultiViewElement(dataObject);
            }
            if (name.equals(DDViewFactory.EJB)) {
                return new EjbMultiViewElement(dataObject);
            }
            return super.createElement(dataObject, name);
        }
    }

    public static class SunWebDDViewFactory
    extends DDViewFactory {
        private static final long serialVersionUID = -8759598009819101745L;

        @Override
        public DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject dataObject) {
            J2EEBaseVersion j2eeVersion;
            ASDDVersion asDDVersion = dataObject.getASDDVersion();
            ArrayList<DDView> views = new ArrayList<DDView>(8);
            views.add(new DDView(dataObject, DDViewFactory.OVERVIEW));
            views.add(new DDView(dataObject, DDViewFactory.SERVLET));
            views.add(new DDView(dataObject, DDViewFactory.SECURITY));
            if (ASDDVersion.SUN_APPSERVER_8_0.compareTo((Object)asDDVersion) <= 0 && ((j2eeVersion = dataObject.getJ2eeModuleVersion()) == null || j2eeVersion.compareSpecification((J2EEBaseVersion)J2EEVersion.J2EE_1_4) >= 0)) {
                views.add(new DDView(dataObject, DDViewFactory.WSSERVICE));
                views.add(new DDView(dataObject, DDViewFactory.JMS));
            }
            views.add(new DDView(dataObject, DDViewFactory.ENVIRONMENT));
            return views.toArray(new DDView[views.size()]);
        }

        @Override
        public MultiViewElement createElement(SunDescriptorDataObject dataObject, String name) {
            if (name.equals(DDViewFactory.OVERVIEW)) {
                return new SunWebOverviewMultiViewElement(dataObject);
            }
            if (name.equals(DDViewFactory.SERVLET)) {
                return new ServletMultiViewElement(dataObject);
            }
            return super.createElement(dataObject, name);
        }
    }
}

