/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetIndexOrderCursor;
import org.tmatesoft.sqljet.core.internal.table.SqlJetIndexScopeCursor;
import org.tmatesoft.sqljet.core.internal.table.SqlJetReverseOrderCursor;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTableDataCursor;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetRunnableWithLock;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetTable
implements ISqlJetTable {
    private final SqlJetDb db;
    private ISqlJetBtree btree;
    private String tableName;
    private boolean write;

    public SqlJetTable(SqlJetDb db, ISqlJetBtree btree, String tableName, boolean write) throws SqlJetException {
        this.db = db;
        this.btree = btree;
        this.tableName = tableName;
        this.write = write;
        if (null == this.getDefinition()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Table not found: " + tableName);
        }
    }

    @Override
    public SqlJetDb getDataBase() {
        return this.db;
    }

    @Override
    public String getPrimaryKeyIndexName() throws SqlJetException {
        ISqlJetTableDef definition = this.getDefinition();
        return definition.isRowIdPrimaryKey() ? null : definition.getPrimaryKeyIndexName();
    }

    @Override
    public ISqlJetTableDef getDefinition() throws SqlJetException {
        return this.btree.getSchema().getTable(this.tableName);
    }

    @Override
    public Set<ISqlJetIndexDef> getIndexesDefs() throws SqlJetException {
        return this.btree.getSchema().getIndexes(this.tableName);
    }

    @Override
    public Set<String> getIndexesNames() throws SqlJetException {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Set<ISqlJetIndexDef> indexesDefs = this.getIndexesDefs();
        if (null != indexesDefs) {
            for (ISqlJetIndexDef indexDef : indexesDefs) {
                if (null == indexDef) continue;
                result.add(indexDef.getName());
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public ISqlJetIndexDef getIndexDef(String name) throws SqlJetException {
        if (null == name && null == (name = this.getPrimaryKeyIndexName())) {
            return null;
        }
        Set<ISqlJetIndexDef> indexesDefs = this.getIndexesDefs();
        if (null != indexesDefs) {
            for (ISqlJetIndexDef indexDef : indexesDefs) {
                if (null == indexDef || !name.equalsIgnoreCase(indexDef.getName())) continue;
                return indexDef;
            }
        }
        return null;
    }

    @Override
    public ISqlJetCursor open() throws SqlJetException {
        return (ISqlJetCursor)this.db.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                return new SqlJetTableDataCursor(new SqlJetBtreeDataTable(SqlJetTable.this.btree, SqlJetTable.this.tableName, SqlJetTable.this.write), db);
            }
        });
    }

    @Override
    public ISqlJetCursor lookup(final String indexName, Object ... key) throws SqlJetException {
        final Object[] k = SqlJetUtility.adjustNumberTypes(key);
        return (ISqlJetCursor)this.db.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                SqlJetBtreeDataTable table = new SqlJetBtreeDataTable(SqlJetTable.this.btree, SqlJetTable.this.tableName, SqlJetTable.this.write);
                SqlJetTable.this.checkIndexName(indexName, table);
                return new SqlJetIndexScopeCursor(table, db, indexName, k, k);
            }
        });
    }

    private Object runWriteTransaction(final ISqlJetTableRun op) throws SqlJetException {
        return this.db.runWriteTransaction(new ISqlJetTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetBtreeDataTable table = new SqlJetBtreeDataTable(SqlJetTable.this.btree, SqlJetTable.this.tableName, SqlJetTable.this.write);
                try {
                    Object object = op.run(table);
                    return object;
                }
                finally {
                    table.close();
                }
            }
        });
    }

    @Override
    public long insert(Object ... values) throws SqlJetException {
        return this.insertOr(null, values);
    }

    @Override
    public long insertByFieldNames(Map<String, Object> values) throws SqlJetException {
        return this.insertByFieldNamesOr(null, values);
    }

    @Override
    public long insertWithRowId(long rowId, Object ... values) throws SqlJetException {
        return this.insertWithRowIdOr(null, rowId, values);
    }

    @Override
    public long insertOr(final SqlJetConflictAction onConflict, final Object ... values) throws SqlJetException {
        return (Long)this.runWriteTransaction(new ISqlJetTableRun(){

            public Object run(ISqlJetBtreeDataTable table) throws SqlJetException {
                return table.insert(onConflict, values);
            }
        });
    }

    @Override
    public long insertByFieldNamesOr(final SqlJetConflictAction onConflict, final Map<String, Object> values) throws SqlJetException {
        return (Long)this.runWriteTransaction(new ISqlJetTableRun(){

            public Object run(ISqlJetBtreeDataTable table) throws SqlJetException {
                return table.insert(onConflict, values);
            }
        });
    }

    @Override
    public long insertWithRowIdOr(final SqlJetConflictAction onConflict, final long rowId, final Object ... values) throws SqlJetException {
        return (Long)this.runWriteTransaction(new ISqlJetTableRun(){

            public Object run(ISqlJetBtreeDataTable table) throws SqlJetException {
                return table.insertWithRowId(onConflict, rowId, values);
            }
        });
    }

    @Override
    public ISqlJetCursor order(final String indexName) throws SqlJetException {
        return (ISqlJetCursor)this.db.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                SqlJetBtreeDataTable table = new SqlJetBtreeDataTable(SqlJetTable.this.btree, SqlJetTable.this.tableName, SqlJetTable.this.write);
                SqlJetTable.this.checkIndexName(indexName, table);
                return new SqlJetIndexOrderCursor(table, db, indexName);
            }
        });
    }

    @Override
    public ISqlJetCursor scope(final String indexName, Object[] firstKey, Object[] lastKey) throws SqlJetException {
        final Object[] first = SqlJetUtility.adjustNumberTypes(firstKey);
        final Object[] last = SqlJetUtility.adjustNumberTypes(lastKey);
        return (ISqlJetCursor)this.db.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                SqlJetBtreeDataTable table = new SqlJetBtreeDataTable(SqlJetTable.this.btree, SqlJetTable.this.tableName, SqlJetTable.this.write);
                SqlJetTable.this.checkIndexName(indexName, table);
                if (SqlJetTable.this.isNeedReverse(SqlJetTable.this.getIndexTable(indexName, table), first, last)) {
                    return new SqlJetReverseOrderCursor(new SqlJetIndexScopeCursor(table, db, indexName, last, first));
                }
                return new SqlJetIndexScopeCursor(table, db, indexName, first, last);
            }
        });
    }

    @Override
    public void clear() throws SqlJetException {
        this.runWriteTransaction(new ISqlJetTableRun(){

            public Object run(ISqlJetBtreeDataTable table) throws SqlJetException {
                table.clear();
                return null;
            }
        });
    }

    private boolean isNeedReverse(ISqlJetBtreeIndexTable indexTable, Object[] firstKey, Object[] lastKey) throws SqlJetException {
        if (firstKey != null && lastKey != null && firstKey.length > 0 && lastKey.length > 0) {
            if (indexTable != null) {
                return indexTable.compareKeys(firstKey, lastKey) < 0;
            }
            if (firstKey.length == 1 && lastKey.length == 1 && firstKey[0] instanceof Long && lastKey[0] instanceof Long) {
                return ((Long)firstKey[0]).compareTo((Long)lastKey[0]) > 0;
            }
        }
        return false;
    }

    private ISqlJetBtreeIndexTable getIndexTable(String indexName, SqlJetBtreeDataTable table) {
        String index = indexName == null ? table.getPrimaryKeyIndex() : indexName;
        return index != null ? table.getIndex(index) : null;
    }

    private void checkIndexName(String indexName, SqlJetBtreeDataTable table) throws SqlJetException {
        if (!this.isIndexNameValid(indexName, table)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Index not exists: %s", indexName));
        }
    }

    private boolean isIndexNameValid(String indexName, SqlJetBtreeDataTable table) {
        if (indexName != null) {
            return this.getIndexTable(indexName, table) != null;
        }
        if (table.getDefinition().isRowIdPrimaryKey()) {
            return true;
        }
        return table.getPrimaryKeyIndex() != null;
    }

    private static interface ISqlJetTableRun {
        public Object run(ISqlJetBtreeDataTable var1) throws SqlJetException;
    }
}

