/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.lifecycle.mapping.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.netbeans.modules.maven.embedder.EmbedderConfiguration;
import org.openide.util.Exceptions;

public final class MavenEmbedder {
    public static final String userHome = System.getProperty("user.home");
    public static final File userMavenConfigurationHome = new File(userHome, ".m2");
    public static final File defaultUserLocalRepository = new File(userMavenConfigurationHome, "repository");
    public static final File DEFAULT_USER_SETTINGS_FILE = new File(userMavenConfigurationHome, "settings.xml");
    public static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home", System.getProperty("user.dir", "")), "conf/settings.xml");
    private final PlexusContainer plexus;
    private final DefaultMaven maven;
    private final ProjectBuilder projectBuilder;
    private final RepositorySystem repositorySystem;
    private final MavenExecutionRequestPopulator populator;
    private final SettingsBuilder settingsBuilder;
    private final EmbedderConfiguration embedderConfiguration;

    MavenEmbedder(EmbedderConfiguration configuration) throws ComponentLookupException {
        this.embedderConfiguration = configuration;
        this.plexus = configuration.getContainer();
        this.maven = (DefaultMaven)this.plexus.lookup(Maven.class);
        this.projectBuilder = (ProjectBuilder)this.plexus.lookup(ProjectBuilder.class);
        this.repositorySystem = (RepositorySystem)this.plexus.lookup(RepositorySystem.class);
        this.settingsBuilder = (SettingsBuilder)this.plexus.lookup(SettingsBuilder.class);
        this.populator = (MavenExecutionRequestPopulator)this.plexus.lookup(MavenExecutionRequestPopulator.class);
    }

    public PlexusContainer getPlexus() {
        return this.plexus;
    }

    public Properties getSystemProperties() {
        return this.embedderConfiguration.getSystemProperties();
    }

    private String getLocalRepositoryPath() {
        if (this.embedderConfiguration.getLocalRepository() != null) {
            return this.embedderConfiguration.getLocalRepository().getAbsolutePath();
        }
        return this.getSettings().getLocalRepository();
    }

    public ArtifactRepository getLocalRepository() {
        try {
            String localRepositoryPath = this.getLocalRepositoryPath();
            if (localRepositoryPath != null) {
                return this.repositorySystem.createLocalRepository(new File(localRepositoryPath));
            }
            return this.repositorySystem.createLocalRepository(RepositorySystem.defaultUserLocalRepository);
        }
        catch (InvalidRepositoryException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Settings getSettings() {
        DefaultSettingsBuildingRequest req = new DefaultSettingsBuildingRequest();
        req.setGlobalSettingsFile(DEFAULT_GLOBAL_SETTINGS_FILE);
        req.setUserSettingsFile(DEFAULT_USER_SETTINGS_FILE);
        req.setSystemProperties(this.getSystemProperties());
        try {
            return this.settingsBuilder.build((SettingsBuildingRequest)req).getEffectiveSettings();
        }
        catch (SettingsBuildingException x) {
            Logger.getLogger(MavenEmbedder.class.getName()).log(Level.FINE, null, x);
            return new Settings();
        }
    }

    public MavenExecutionResult readProjectWithDependencies(MavenExecutionRequest req) {
        File pomFile = req.getPom();
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        try {
            ProjectBuildingRequest configuration = req.getProjectBuildingRequest();
            configuration.setValidationLevel(0);
            configuration.setResolveDependencies(true);
            configuration.setRepositorySession(this.maven.newRepositorySession(req));
            ProjectBuildingResult projectBuildingResult = this.projectBuilder.build(pomFile, configuration);
            result.setProject(projectBuildingResult.getProject());
            result.setDependencyResolutionResult(projectBuildingResult.getDependencyResolutionResult());
        }
        catch (ProjectBuildingException ex) {
            return result.addException((Throwable)ex);
        }
        return result;
    }

    public MavenProject readProject(File fallback) {
        try {
            MavenExecutionRequest req = this.createMavenExecutionRequest();
            req.setOffline(this.embedderConfiguration.isOffline());
            ProjectBuildingRequest configuration = req.getProjectBuildingRequest();
            configuration.setValidationLevel(0);
            configuration.setRepositorySession(this.maven.newRepositorySession(req));
            return this.projectBuilder.build(fallback, configuration).getProject();
        }
        catch (ProjectBuildingException ex) {
            return new MavenProject();
        }
    }

    public Artifact createArtifactWithClassifier(String groupId, String artifactId, String version, String type, String classifier) {
        return this.repositorySystem.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String packaging) {
        return this.repositorySystem.createArtifact(groupId, artifactId, version, packaging);
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type) {
        return this.repositorySystem.createArtifact(groupId, artifactId, version, scope, type);
    }

    public Artifact createProjectArtifact(String groupId, String artifactId, String version) {
        return this.repositorySystem.createProjectArtifact(groupId, artifactId, version);
    }

    public void resolve(Artifact sources, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactResolutionRequest req = new ArtifactResolutionRequest();
        req.setLocalRepository(localRepository);
        req.setRemoteRepositories(remoteRepositories);
        req.setArtifact(sources);
        this.repositorySystem.resolve(req);
    }

    public ProjectBuildingResult buildProject(Artifact art, ProjectBuildingRequest req) throws ProjectBuildingException {
        if (req.getLocalRepository() == null) {
            req.setLocalRepository(this.getLocalRepository());
        }
        MavenExecutionRequest request = this.createMavenExecutionRequest();
        req.setProcessPlugins(false);
        req.setRepositorySession(this.maven.newRepositorySession(request));
        return this.projectBuilder.build(art, req);
    }

    public MavenExecutionResult execute(MavenExecutionRequest req) {
        return this.maven.execute(req);
    }

    public List<String> getLifecyclePhases() {
        LifecycleMapping lifecycleMapping = this.lookupComponent(LifecycleMapping.class);
        if (lifecycleMapping != null) {
            TreeSet phases = new TreeSet();
            Map lifecycles = lifecycleMapping.getLifecycles();
            for (Lifecycle lifecycle : lifecycles.values()) {
                phases.addAll(lifecycle.getPhases().keySet());
            }
            return new ArrayList<String>(phases);
        }
        return Collections.emptyList();
    }

    public <T> T lookupComponent(Class<T> clazz) {
        try {
            return (T)this.plexus.lookup(clazz);
        }
        catch (ComponentLookupException ex) {
            Logger.getLogger(MavenEmbedder.class.getName()).warning(ex.getMessage());
            return null;
        }
    }

    public MavenExecutionRequest createMavenExecutionRequest() {
        DefaultMavenExecutionRequest req = new DefaultMavenExecutionRequest();
        ArtifactRepository localRepository = this.getLocalRepository();
        req.setLocalRepository(localRepository);
        req.setLocalRepositoryPath(localRepository.getBasedir());
        if (req.getRemoteRepositories() == null) {
            req.setRemoteRepositories(Collections.emptyList());
        }
        if (DEFAULT_GLOBAL_SETTINGS_FILE != null && DEFAULT_GLOBAL_SETTINGS_FILE.exists()) {
            req.setGlobalSettingsFile(DEFAULT_GLOBAL_SETTINGS_FILE);
        }
        if (DEFAULT_USER_SETTINGS_FILE != null && DEFAULT_USER_SETTINGS_FILE.exists()) {
            req.setUserSettingsFile(DEFAULT_USER_SETTINGS_FILE);
        }
        req.setSystemProperties(this.getSystemProperties());
        req.setOffline(this.embedderConfiguration.isOffline());
        try {
            this.populator.populateDefaults((MavenExecutionRequest)req);
            this.populator.populateFromSettings((MavenExecutionRequest)req, this.getSettings());
        }
        catch (MavenExecutionRequestPopulationException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
        return req;
    }
}

