/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.repository.RepositorySystem;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.openide.util.Exceptions;

class NBRepositoryModelResolver
implements ModelResolver {
    private RepositorySystem repositorySystem;
    private List<ArtifactRepository> remoteRepositories = new ArrayList<ArtifactRepository>();

    public NBRepositoryModelResolver(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    private NBRepositoryModelResolver(NBRepositoryModelResolver original) {
        this.repositorySystem = original.repositorySystem;
        this.remoteRepositories = new ArrayList<ArtifactRepository>(original.remoteRepositories);
    }

    public ModelResolver newCopy() {
        return new NBRepositoryModelResolver(this);
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
        try {
            ArtifactRepository repo = this.repositorySystem.buildArtifactRepository(repository);
            this.remoteRepositories.add(repo);
            this.remoteRepositories = this.repositorySystem.getEffectiveRepositories(this.remoteRepositories);
        }
        catch (org.apache.maven.artifact.InvalidRepositoryException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        Artifact artifactParent = this.repositorySystem.createProjectArtifact(groupId, artifactId, version);
        MavenEmbedder onlineEmbedder = EmbedderFactory.getOnlineEmbedder();
        try {
            onlineEmbedder.resolve(artifactParent, this.remoteRepositories, onlineEmbedder.getLocalRepository());
        }
        catch (ArtifactResolutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw new UnresolvableModelException(ex.getMessage(), groupId, artifactId, version);
        }
        catch (ArtifactNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw new UnresolvableModelException(ex.getMessage(), groupId, artifactId, version);
        }
        return new FileModelSource(artifactParent.getFile());
    }
}

