/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AssignmentToItself
extends AbstractHint {
    private final AtomicBoolean cancel = new AtomicBoolean();
    private Set<Tree.Kind> KINDS = Collections.singleton(Tree.Kind.ASSIGNMENT);

    public AssignmentToItself() {
        super(true, true, AbstractHint.HintSeverity.WARNING, "SillyAssignment");
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return this.KINDS;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo info, TreePath treePath) {
        this.cancel.set(false);
        Tree node = treePath.getLeaf();
        if (node.getKind() != Tree.Kind.ASSIGNMENT) {
            return null;
        }
        AssignmentTree tree = (AssignmentTree)node;
        if (this.ignore(treePath, tree, info.getTrees())) {
            return null;
        }
        TreePath tpVar = new TreePath(treePath, tree.getVariable());
        TreePath tpExp = new TreePath(treePath, tree.getExpression());
        Element eVar = info.getTrees().getElement(tpVar);
        Element eExp = info.getTrees().getElement(tpExp);
        if (eVar != null && eExp != null && ((Object)eVar).equals(eExp)) {
            ArrayList fixes = new ArrayList();
            ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), fixes, (FileObject)info.getFileObject(), (int)((int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), tree)), (int)((int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), tree)));
            return Collections.singletonList(ed);
        }
        return null;
    }

    @Override
    public void cancel() {
        this.cancel.set(true);
    }

    @Override
    public String getId() {
        return "AssignmentToItself";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(AssignmentToItself.class, (String)"LBL_ATI");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(AssignmentToItself.class, (String)"DSC_ATI");
    }

    private boolean ignore(TreePath tp, AssignmentTree at, Trees trees) {
        ExpressionTree var = at.getVariable();
        ExpressionTree exp = at.getExpression();
        ArrayList varElements = new ArrayList();
        ArrayList expElements = new ArrayList();
        MethodCallScanner scanner = new MethodCallScanner(this.cancel, trees);
        Boolean varMI = (Boolean)scanner.scan(new TreePath(tp, var), varElements);
        varMI = varMI == null ? false : varMI;
        scanner = new MethodCallScanner(this.cancel, trees);
        Boolean expMI = (Boolean)scanner.scan(new TreePath(tp, exp), expElements);
        expMI = expMI == null ? false : expMI;
        if (varMI.booleanValue() || expMI.booleanValue()) {
            return true;
        }
        boolean equal = ((Object)varElements).equals(expElements);
        if (equal && var.getKind() == Tree.Kind.MEMBER_SELECT && exp.getKind() == Tree.Kind.MEMBER_SELECT) {
            ExpressionTree varExp = ((MemberSelectTree)var).getExpression();
            ExpressionTree expExp = ((MemberSelectTree)exp).getExpression();
            if (varExp.getKind() == Tree.Kind.ARRAY_ACCESS && expExp.getKind() == Tree.Kind.ARRAY_ACCESS && !((ArrayAccessTree)varExp).getIndex().toString().equals(((ArrayAccessTree)expExp).getIndex().toString())) {
                return true;
            }
        }
        return !equal;
    }

    private static class ATIFix
    implements Fix,
    Task<WorkingCopy> {
        private static final int REMOVE = 0;
        private static final int QUALIFY = 1;
        private static final int NEW_PARAMETER = 2;
        private static final int NEW_FIELD = 3;
        private int kind;
        private TreePath treePath;
        private FileObject file;

        public ATIFix(int kind, TreePath treePath, FileObject file) {
            this.kind = kind;
            this.treePath = treePath;
            this.file = file;
        }

        public String getText() {
            switch (this.kind) {
                case 0: {
                    return NbBundle.getMessage(AssignmentToItself.class, (String)"LBL_ATI_Remove_FIX");
                }
                case 1: {
                    return NbBundle.getMessage(AssignmentToItself.class, (String)"LBL_ATI_Qualify_FIX");
                }
                case 2: {
                    return NbBundle.getMessage(AssignmentToItself.class, (String)"LBL_ATI_NewParameter_FIX");
                }
                case 3: {
                    return NbBundle.getMessage(AssignmentToItself.class, (String)"LBL_ATI_NewField_FIX");
                }
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ChangeInfo implement() throws Exception {
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            try {
                js.runModificationTask((Task)this).commit();
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            return null;
        }

        public void run(WorkingCopy workingCopy) throws Exception {
        }
    }

    private static class MethodCallScanner
    extends CancellableTreePathScanner<Boolean, List<Element>> {
        private Trees trees;

        public MethodCallScanner(AtomicBoolean cancel, Trees trees) {
            super(cancel);
            this.trees = trees;
        }

        public Boolean visitMemberSelect(MemberSelectTree t, List<Element> l) {
            l.add(this.trees.getElement(this.getCurrentPath()));
            return (Boolean)super.visitMemberSelect(t, l);
        }

        public Boolean visitIdentifier(IdentifierTree t, List<Element> l) {
            if (!"this".equals(t.getName().toString())) {
                l.add(this.trees.getElement(this.getCurrentPath()));
            }
            return (Boolean)super.visitIdentifier(t, l);
        }

        public Boolean visitMethodInvocation(MethodInvocationTree arg0, List<Element> arg1) {
            return true;
        }
    }
}

