/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class EqualsMethodHint
extends AbstractHint {
    private static final String SUPPRESS_KEY = "EqualsWhichDoesntCheckParameterClass";

    public EqualsMethodHint() {
        super(true, false, AbstractHint.HintSeverity.WARNING, SUPPRESS_KEY);
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(EqualsMethodHint.class, (String)"DSC_EqualsMethod");
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo info, TreePath treePath) {
        if (!this.getTreeKinds().contains((Object)treePath.getLeaf().getKind())) {
            return null;
        }
        if (info.getTreeUtilities().isSynthetic(treePath)) {
            return null;
        }
        MethodTree mt = (MethodTree)treePath.getLeaf();
        if (!mt.getName().contentEquals("equals")) {
            return null;
        }
        Element current = info.getTrees().getElement(treePath);
        if (current == null || current.getKind() != ElementKind.METHOD) {
            return null;
        }
        ExecutableElement currentMethod = (ExecutableElement)current;
        ExecutableElement equals = null;
        TypeElement jlObject = info.getElements().getTypeElement("java.lang.Object");
        if (jlObject != null) {
            for (ExecutableElement ee : ElementFilter.methodsIn(jlObject.getEnclosedElements())) {
                if (!ee.getSimpleName().contentEquals("equals")) continue;
                equals = ee;
                break;
            }
        }
        if (equals == null || !info.getElements().overrides(currentMethod, equals, (TypeElement)currentMethod.getEnclosingElement())) {
            return null;
        }
        Element param = info.getTrees().getElement(new TreePath(treePath, mt.getParameters().get(0)));
        if (param == null || param.getKind() != ElementKind.PARAMETER) {
            return null;
        }
        if (mt.getBody() == null) {
            return null;
        }
        try {
            new VisitorImpl(info, param).scan(new TreePath(treePath, mt.getBody()), null);
        }
        catch (Found f) {
            return null;
        }
        int[] span = info.getTreeUtilities().findNameSpan(mt);
        if (span == null) {
            return null;
        }
        ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(EqualsMethodHint.class, (String)"ERR_EQUALS_NOT_CHECKING_TYPE"), FixFactory.createSuppressWarnings(info, treePath, SUPPRESS_KEY), (FileObject)info.getFileObject(), (int)span[0], (int)span[1]);
        return Collections.singletonList(ed);
    }

    @Override
    public String getId() {
        return EqualsMethodHint.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(EqualsMethodHint.class, (String)"DN_EqualsMethod");
    }

    @Override
    public void cancel() {
    }

    private static final class Found
    extends RuntimeException {
        private Found() {
        }
    }

    private static final class VisitorImpl
    extends TreePathScanner<Void, Void> {
        private CompilationInfo info;
        private Element parameter;

        public VisitorImpl(CompilationInfo info, Element parameter) {
            this.info = info;
            this.parameter = parameter;
        }

        @Override
        public Void visitInstanceOf(InstanceOfTree node, Void p) {
            Element e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getExpression()));
            if (((Object)this.parameter).equals(e)) {
                throw new Found();
            }
            return (Void)super.visitInstanceOf(node, p);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
            if (node.getArguments().isEmpty() && node.getMethodSelect().getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree mst = (MemberSelectTree)node.getMethodSelect();
                Element e = this.info.getTrees().getElement(new TreePath(new TreePath(this.getCurrentPath(), mst), mst.getExpression()));
                if (((Object)this.parameter).equals(e) && mst.getIdentifier().contentEquals("getClass")) {
                    throw new Found();
                }
            }
            return (Void)super.visitMethodInvocation(node, p);
        }
    }
}

