/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class OverridableMethodCallInConstructor {
    public static ErrorDescription hint(HintContext ctx) {
        MethodInvocationTree mit = (MethodInvocationTree)ctx.getPath().getLeaf();
        CompilationInfo info = ctx.getInfo();
        TreePath enclosingMethod = Utilities.findEnclosingMethodOrConstructor(ctx, ctx.getPath());
        if (enclosingMethod == null) {
            return null;
        }
        Element enclosingMethodElement = ctx.getInfo().getTrees().getElement(enclosingMethod);
        if (enclosingMethodElement == null || enclosingMethodElement.getKind() != ElementKind.CONSTRUCTOR) {
            return null;
        }
        Element methodInvocationElement = info.getTrees().getElement(new TreePath(ctx.getPath(), mit.getMethodSelect()));
        if (methodInvocationElement == null || methodInvocationElement.getKind() != ElementKind.METHOD) {
            return null;
        }
        Element classElement = methodInvocationElement.getEnclosingElement();
        if (classElement == null || classElement.getKind() != ElementKind.CLASS) {
            return null;
        }
        if (!((Object)classElement).equals(enclosingMethodElement.getEnclosingElement())) {
            return null;
        }
        if (classElement.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        Set<Modifier> modifiers = methodInvocationElement.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.FINAL) || modifiers.contains((Object)Modifier.STATIC)) {
            return null;
        }
        if (!OverridableMethodCallInConstructor.invocationOnThis(mit)) {
            return null;
        }
        TreePath methodDeclaration = ctx.getInfo().getTrees().getPath(methodInvocationElement);
        if (methodDeclaration == null || ctx.getInfo().getTreeUtilities().isSynthetic(methodDeclaration)) {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, mit, NbBundle.getMessage(OverridableMethodCallInConstructor.class, (String)"MSG_org.netbeans.modules.java.hints.OverridableMethodCallInConstructor"), OverridableMethodCallInConstructor.computeFixes((MethodTree)methodDeclaration.getLeaf(), classElement, ctx));
    }

    private static Fix[] computeFixes(MethodTree mt, Element classElement, HintContext ctx) {
        ArrayList<Fix> result = new ArrayList<Fix>();
        ClassTree ct = ctx.getInfo().getTrees().getTree((TypeElement)classElement);
        result.add(FixFactory.addModifiersFix(ctx.getInfo(), TreePath.getPath(ctx.getInfo().getCompilationUnit(), (Tree)ct.getModifiers()), Collections.singleton(Modifier.FINAL), NbBundle.getMessage(OverridableMethodCallInConstructor.class, (String)"FIX_MakeClass", (Object)"final", (Object)ct.getSimpleName())));
        Set<Modifier> flags = mt.getModifiers().getFlags();
        result.add(FixFactory.addModifiersFix(ctx.getInfo(), TreePath.getPath(ctx.getInfo().getCompilationUnit(), (Tree)mt.getModifiers()), Collections.singleton(Modifier.FINAL), NbBundle.getMessage(OverridableMethodCallInConstructor.class, (String)"FIX_MakeMethod", (Object)"final", (Object)mt.getName())));
        result.add(FixFactory.addModifiersFix(ctx.getInfo(), TreePath.getPath(ctx.getInfo().getCompilationUnit(), (Tree)mt.getModifiers()), Collections.singleton(Modifier.STATIC), NbBundle.getMessage(OverridableMethodCallInConstructor.class, (String)"FIX_MakeMethod", (Object)"static", (Object)mt.getName())));
        result.add(FixFactory.changeModifiersFix(ctx.getInfo(), TreePath.getPath(ctx.getInfo().getCompilationUnit(), (Tree)mt.getModifiers()), Collections.singleton(Modifier.PRIVATE), flags, NbBundle.getMessage(OverridableMethodCallInConstructor.class, (String)"FIX_MakeMethod", (Object)"private", (Object)mt.getName())));
        return result.toArray(new Fix[result.size()]);
    }

    private static boolean invocationOnThis(MethodInvocationTree mit) {
        ExpressionTree select = mit.getMethodSelect();
        switch (select.getKind()) {
            case IDENTIFIER: {
                return true;
            }
            case MEMBER_SELECT: {
                if (((MemberSelectTree)select).getExpression().getKind() != Tree.Kind.IDENTIFIER) break;
                IdentifierTree ident = (IdentifierTree)((MemberSelectTree)select).getExpression();
                return ident.getName().contentEquals("this");
            }
        }
        return false;
    }
}

