/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.modules.java.hints.infrastructure.Pair;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class Utilities {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String DEFAULT_NAME = "name";
    private static final Map<Tree.Kind, String> operator2DN = new HashMap<Tree.Kind, String>();

    public static String guessName(CompilationInfo info, TreePath tp) {
        if (tp.getLeaf().getKind() == Tree.Kind.VARIABLE) {
            return ((VariableTree)tp.getLeaf()).getName().toString();
        }
        ExpressionTree et = (ExpressionTree)tp.getLeaf();
        String name = Utilities.getName(et);
        if (name == null) {
            Object guess;
            if (et instanceof LiteralTree && (guess = ((LiteralTree)et).getValue()) != null && guess instanceof String) {
                return Utilities.guessLiteralName((String)guess);
            }
            return DEFAULT_NAME;
        }
        Scope s = info.getTrees().getScope(tp);
        int counter = 0;
        boolean cont = true;
        String proposedName = name;
        block0: while (cont) {
            proposedName = name + (counter != 0 ? String.valueOf(counter) : "");
            cont = false;
            for (Element e : info.getElementUtilities().getLocalMembersAndVars(s, (ElementUtilities.ElementAcceptor)new VariablesFilter())) {
                if (!proposedName.equals(e.getSimpleName().toString())) continue;
                ++counter;
                cont = true;
                continue block0;
            }
        }
        return proposedName;
    }

    private static String guessLiteralName(String str) {
        StringBuffer sb = new StringBuffer();
        if (str.length() == 0) {
            return DEFAULT_NAME;
        }
        char first = str.charAt(0);
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            sb.append(first);
        }
        for (int i = 1; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == ' ') {
                sb.append('_');
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
            }
            if (i > 40) break;
        }
        if (sb.length() == 0) {
            return DEFAULT_NAME;
        }
        return sb.toString();
    }

    public static boolean isEnhancedForLoopIdentifier(TreePath tp) {
        if (tp == null || tp.getLeaf().getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        TreePath parent = tp.getParentPath();
        if (parent == null || parent.getLeaf().getKind() != Tree.Kind.VARIABLE) {
            return false;
        }
        TreePath context = parent.getParentPath();
        return context != null && context.getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP;
    }

    public static TypeMirror getIterableGenericType(CompilationInfo info, TreePath iterable) {
        TypeElement iterableElement = info.getElements().getTypeElement("java.lang.Iterable");
        if (iterableElement == null) {
            return null;
        }
        TypeMirror iterableType = info.getTrees().getTypeMirror(iterable);
        if (iterableType == null) {
            return null;
        }
        TypeMirror designedType = null;
        if (iterableType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)iterableType;
            if (!info.getTypes().isSubtype(info.getTypes().erasure(declaredType), info.getTypes().erasure(iterableElement.asType()))) {
                return null;
            }
            ExecutableElement iteratorMethod = (ExecutableElement)iterableElement.getEnclosedElements().get(0);
            ExecutableType iteratorMethodType = (ExecutableType)info.getTypes().asMemberOf(declaredType, iteratorMethod);
            List<? extends TypeMirror> typeArguments = ((DeclaredType)iteratorMethodType.getReturnType()).getTypeArguments();
            if (!typeArguments.isEmpty()) {
                designedType = typeArguments.get(0);
            } else {
                TypeElement jlObject = info.getElements().getTypeElement("java.lang.Object");
                if (jlObject != null) {
                    designedType = jlObject.asType();
                }
            }
        } else if (iterableType.getKind() == TypeKind.ARRAY) {
            designedType = ((ArrayType)iterableType).getComponentType();
        }
        if (designedType == null) {
            return null;
        }
        return Utilities.resolveCapturedType(info, designedType);
    }

    public static String getName(TypeMirror tm) {
        if (tm.getKind().isPrimitive()) {
            return "" + Character.toLowerCase(tm.getKind().name().charAt(0));
        }
        switch (tm.getKind()) {
            case DECLARED: {
                DeclaredType dt = (DeclaredType)tm;
                return Utilities.firstToLower(dt.asElement().getSimpleName().toString());
            }
            case ARRAY: {
                return Utilities.getName(((ArrayType)tm).getComponentType());
            }
        }
        return DEFAULT_NAME;
    }

    public static String getName(ExpressionTree et) {
        return Utilities.getName((Tree)et);
    }

    public static String getName(Tree et) {
        return Utilities.adjustName(Utilities.getNameRaw(et));
    }

    private static String getNameRaw(Tree et) {
        if (et == null) {
            return null;
        }
        switch (et.getKind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)et).getName().toString();
            }
            case METHOD_INVOCATION: {
                return Utilities.getName(((MethodInvocationTree)et).getMethodSelect());
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)et).getIdentifier().toString();
            }
            case NEW_CLASS: {
                return Utilities.firstToLower(Utilities.getName(((NewClassTree)et).getIdentifier()));
            }
            case PARAMETERIZED_TYPE: {
                return Utilities.firstToLower(Utilities.getName(((ParameterizedTypeTree)et).getType()));
            }
        }
        return null;
    }

    static String adjustName(String name) {
        if (name == null) {
            return null;
        }
        String shortName = null;
        if (name.startsWith("get") && name.length() > 3) {
            shortName = name.substring(3);
        }
        if (name.startsWith("is") && name.length() > 2) {
            shortName = name.substring(2);
        }
        if (shortName != null) {
            return Utilities.firstToLower(shortName);
        }
        if (SourceVersion.isKeyword(name)) {
            return "a" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    private static String firstToLower(String name) {
        if (name.length() == 0) {
            return null;
        }
        String cand = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        if (SourceVersion.isKeyword(cand)) {
            cand = "a" + name;
        }
        return cand;
    }

    public static ChangeInfo commitAndComputeChangeInfo(FileObject target, final ModificationResult diff, final Object tag) throws IOException {
        ChangeInfo result;
        block6: {
            if (!target.canWrite()) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(Utilities.class, (String)"ERR_ReadOnlyTargetFile", (Object)FileUtil.getFileDisplayName((FileObject)target)), 2);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                return null;
            }
            List differences = diff.getDifferences(target);
            result = null;
            diff.commit();
            try {
                if (differences == null) break block6;
                for (ModificationResult.Difference d : differences) {
                    if (d.getNewText() == null) continue;
                    final PositionRef start = d.getStartPosition();
                    StyledDocument doc = start.getCloneableEditorSupport().getDocument();
                    if (doc == null) {
                        doc = start.getCloneableEditorSupport().openDocument();
                    }
                    final Position[] pos = new Position[2];
                    final StyledDocument fdoc = doc;
                    doc.render(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int[] span = diff.getSpan(tag);
                                if (span != null) {
                                    pos[0] = fdoc.createPosition(span[0]);
                                    pos[1] = fdoc.createPosition(span[1]);
                                } else {
                                    pos[0] = NbDocument.createPosition((Document)fdoc, (int)start.getOffset(), (Position.Bias)Position.Bias.Backward);
                                    pos[1] = pos[0];
                                }
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                    if (pos[0] != null) {
                        result = new ChangeInfo(target, pos[0], pos[1]);
                    }
                    break;
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return result;
    }

    public static boolean isMethodHeaderInsideGuardedBlock(CompilationInfo info, MethodTree method) {
        try {
            Document doc = info.getDocument();
            if (doc instanceof GuardedDocument) {
                GuardedDocument bdoc = (GuardedDocument)doc;
                int methodStart = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), method);
                int methodEnd = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), method);
                return (bdoc.getGuardedBlockChain().compareBlock(methodStart, methodEnd) & 1) != 0;
            }
            return false;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    public static TypeMirror resolveCapturedType(CompilationInfo info, TypeMirror tm) {
        TypeMirror type = Utilities.resolveCapturedTypeInt(info, tm);
        if (type.getKind() == TypeKind.WILDCARD) {
            TypeMirror tmirr = ((WildcardType)type).getExtendsBound();
            if (tmirr != null) {
                return tmirr;
            }
            return info.getElements().getTypeElement("java.lang.Object").asType();
        }
        return type;
    }

    private static TypeMirror resolveCapturedTypeInt(CompilationInfo info, TypeMirror tm) {
        WildcardType orig = SourceUtils.resolveCapturedType((TypeMirror)tm);
        if (orig != null) {
            TypeMirror extendsBound;
            WildcardType rct;
            if (orig.getKind() == TypeKind.WILDCARD && (rct = SourceUtils.resolveCapturedType((TypeMirror)((extendsBound = orig.getExtendsBound()) != null ? extendsBound : orig.getSuperBound()))) != null) {
                return rct;
            }
            return orig;
        }
        if (tm.getKind() == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)tm;
            LinkedList<TypeMirror> typeArguments = new LinkedList<TypeMirror>();
            for (TypeMirror typeMirror : dt.getTypeArguments()) {
                typeArguments.add(Utilities.resolveCapturedTypeInt(info, typeMirror));
            }
            TypeMirror enclosingType = dt.getEnclosingType();
            if (enclosingType.getKind() == TypeKind.DECLARED) {
                return info.getTypes().getDeclaredType((DeclaredType)enclosingType, (TypeElement)dt.asElement(), typeArguments.toArray(new TypeMirror[0]));
            }
            return info.getTypes().getDeclaredType((TypeElement)dt.asElement(), typeArguments.toArray(new TypeMirror[0]));
        }
        if (tm.getKind() == TypeKind.ARRAY) {
            ArrayType at = (ArrayType)tm;
            return info.getTypes().getArrayType(Utilities.resolveCapturedTypeInt(info, at.getComponentType()));
        }
        return tm;
    }

    public static <T extends Tree> T copyComments(WorkingCopy wc, Tree from, T to) {
        Utilities.copyComments(wc, from, to, true);
        Utilities.copyComments(wc, from, to, false);
        return to;
    }

    public static <T extends Tree> T copyComments(WorkingCopy wc, Tree from, T to, boolean preceding) {
        GeneratorUtilities.get((WorkingCopy)wc).copyComments(from, to, preceding);
        return to;
    }

    public static TypeMirror convertIfAnonymous(TypeMirror tm) {
        Element el;
        EnumSet<ElementKind> fm = EnumSet.of(ElementKind.METHOD, ElementKind.FIELD);
        if (tm instanceof DeclaredType && ((el = ((DeclaredType)tm).asElement()).getSimpleName().length() == 0 || fm.contains((Object)el.getEnclosingElement().getKind()))) {
            List<? extends TypeMirror> interfaces = ((TypeElement)el).getInterfaces();
            tm = interfaces.isEmpty() ? ((TypeElement)el).getSuperclass() : interfaces.get(0);
        }
        return tm;
    }

    public static List<List<TreePath>> splitStringConcatenationToElements(CompilationInfo info, TreePath tree) {
        return Utilities.sortOut(info, Utilities.linearize(tree));
    }

    private static List<TreePath> linearize(TreePath tree) {
        LinkedList<TreePath> todo = new LinkedList<TreePath>();
        LinkedList<TreePath> result = new LinkedList<TreePath>();
        todo.add(tree);
        while (!todo.isEmpty()) {
            TreePath tp = (TreePath)todo.remove(0);
            if (tp.getLeaf().getKind() != Tree.Kind.PLUS) {
                result.add(tp);
                continue;
            }
            BinaryTree bt = (BinaryTree)tp.getLeaf();
            todo.add(0, new TreePath(tp, bt.getRightOperand()));
            todo.add(0, new TreePath(tp, bt.getLeftOperand()));
        }
        return result;
    }

    private static List<List<TreePath>> sortOut(CompilationInfo info, List<TreePath> trees) {
        LinkedList<List<TreePath>> result = new LinkedList<List<TreePath>>();
        LinkedList<TreePath> currentCluster = new LinkedList<TreePath>();
        for (TreePath t : trees) {
            if (Utilities.isConstantString(info, t, true)) {
                currentCluster.add(t);
                continue;
            }
            if (!currentCluster.isEmpty()) {
                result.add(currentCluster);
                currentCluster = new LinkedList();
            }
            result.add(new LinkedList<TreePath>(Collections.singletonList(t)));
        }
        if (!currentCluster.isEmpty()) {
            result.add(currentCluster);
        }
        return result;
    }

    public static boolean isConstantString(CompilationInfo info, TreePath tp) {
        return Utilities.isConstantString(info, tp, false);
    }

    public static boolean isConstantString(CompilationInfo info, TreePath tp, boolean acceptsChars) {
        if (tp.getLeaf().getKind() == Tree.Kind.STRING_LITERAL) {
            return true;
        }
        if (acceptsChars && tp.getLeaf().getKind() == Tree.Kind.CHAR_LITERAL) {
            return true;
        }
        Element el = info.getTrees().getElement(tp);
        if (el != null && el.getKind() == ElementKind.FIELD && ((VariableElement)el).getConstantValue() instanceof String) {
            return true;
        }
        if (tp.getLeaf().getKind() != Tree.Kind.PLUS) {
            return false;
        }
        List<List<TreePath>> sorted = Utilities.splitStringConcatenationToElements(info, tp);
        if (sorted.size() != 1) {
            return false;
        }
        List<TreePath> part = sorted.get(0);
        for (TreePath c : part) {
            if (!Utilities.isConstantString(info, c, acceptsChars)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStringOrCharLiteral(Tree t) {
        return t != null && (t.getKind() == Tree.Kind.STRING_LITERAL || t.getKind() == Tree.Kind.CHAR_LITERAL);
    }

    @NonNull
    public static Collection<? extends TreePath> resolveFieldGroup(@NonNull CompilationInfo info, @NonNull TreePath variable) {
        Collection<Tree> children;
        Tree leaf = variable.getLeaf();
        if (leaf.getKind() != Tree.Kind.VARIABLE) {
            return Collections.singleton(variable);
        }
        TreePath parentPath = variable.getParentPath();
        switch (parentPath.getLeaf().getKind()) {
            case BLOCK: {
                children = ((BlockTree)parentPath.getLeaf()).getStatements();
                break;
            }
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                children = ((ClassTree)parentPath.getLeaf()).getMembers();
                break;
            }
            case CASE: {
                children = ((CaseTree)parentPath.getLeaf()).getStatements();
                break;
            }
            default: {
                children = Collections.singleton(leaf);
            }
        }
        LinkedList<TreePath> result = new LinkedList<TreePath>();
        ModifiersTree currentModifiers = ((VariableTree)leaf).getModifiers();
        for (Tree c : children) {
            if (c.getKind() != Tree.Kind.VARIABLE || ((VariableTree)c).getModifiers() != currentModifiers) continue;
            result.add(new TreePath(parentPath, c));
        }
        return result;
    }

    public static String shortDisplayName(CompilationInfo info, ExpressionTree expression) {
        return (String)new HintDisplayNameVisitor(info).scan(expression, null);
    }

    public static TreePath findEnclosingMethodOrConstructor(HintContext ctx, TreePath from) {
        while (from != null && from.getLeaf().getKind() != Tree.Kind.METHOD && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)from.getLeaf().getKind())) {
            from = from.getParentPath();
        }
        if (from != null && from.getLeaf().getKind() == Tree.Kind.METHOD) {
            return from;
        }
        return null;
    }

    public static boolean isInConstructor(HintContext ctx) {
        TreePath method = Utilities.findEnclosingMethodOrConstructor(ctx, ctx.getPath());
        if (method == null) {
            return false;
        }
        Element enclosingMethodElement = ctx.getInfo().getTrees().getElement(method);
        return enclosingMethodElement != null && enclosingMethodElement.getKind() == ElementKind.CONSTRUCTOR;
    }

    public static Pair<List<? extends TypeMirror>, List<String>> resolveArguments(CompilationInfo info, TreePath invocation, List<? extends ExpressionTree> realArguments, Element target) {
        LinkedList<TypeMirror> argumentTypes = new LinkedList<TypeMirror>();
        LinkedList<String> argumentNames = new LinkedList<String>();
        HashSet<String> usedArgumentNames = new HashSet<String>();
        for (ExpressionTree expressionTree : realArguments) {
            TypeMirror tm = info.getTrees().getTypeMirror(new TreePath(invocation, expressionTree));
            if ((tm = Utilities.convertIfAnonymous(tm)) == null || Utilities.containsErrorsRecursively(tm)) {
                return null;
            }
            Collection<TypeVariable> typeVars = Utilities.containedTypevarsRecursively(tm);
            if (!Utilities.allTypeVarsAccessible(typeVars, target)) {
                return null;
            }
            if (tm.getKind() == TypeKind.NULL) {
                tm = info.getElements().getTypeElement("java.lang.Object").asType();
            }
            argumentTypes.add(tm);
            String proposedName = Utilities.getName(expressionTree);
            if (proposedName == null) {
                proposedName = Utilities.getName(tm);
            }
            if (proposedName == null) {
                proposedName = "arg";
            }
            if (usedArgumentNames.contains(proposedName)) {
                int num = 0;
                while (usedArgumentNames.contains(proposedName + num)) {
                    ++num;
                }
                proposedName = proposedName + num;
            }
            usedArgumentNames.add(proposedName);
            argumentNames.add(proposedName);
        }
        return new Pair<List<? extends TypeMirror>, List<String>>(argumentTypes, argumentNames);
    }

    public static boolean containsErrorsRecursively(TypeMirror tm) {
        switch (tm.getKind()) {
            case ERROR: {
                return true;
            }
            case DECLARED: {
                DeclaredType type = (DeclaredType)tm;
                for (TypeMirror typeMirror : type.getTypeArguments()) {
                    if (!Utilities.containsErrorsRecursively(typeMirror)) continue;
                    return true;
                }
                return false;
            }
            case ARRAY: {
                return Utilities.containsErrorsRecursively(((ArrayType)tm).getComponentType());
            }
            case WILDCARD: {
                if (((WildcardType)tm).getExtendsBound() != null && Utilities.containsErrorsRecursively(((WildcardType)tm).getExtendsBound())) {
                    return true;
                }
                return ((WildcardType)tm).getSuperBound() != null && Utilities.containsErrorsRecursively(((WildcardType)tm).getSuperBound());
            }
        }
        return false;
    }

    public static boolean exitsFromAllBranchers(CompilationInfo info, TreePath from) {
        ExitsFromAllBranches efab = new ExitsFromAllBranches(info);
        return efab.scan(from, null) == Boolean.TRUE;
    }

    @NonNull
    public static Collection<TypeVariable> containedTypevarsRecursively(@NullAllowed TypeMirror tm) {
        if (tm == null) {
            return Collections.emptyList();
        }
        LinkedList<TypeVariable> typeVars = new LinkedList<TypeVariable>();
        Utilities.containedTypevarsRecursively(tm, typeVars);
        return typeVars;
    }

    private static void containedTypevarsRecursively(@NonNull TypeMirror tm, @NonNull Collection<TypeVariable> typeVars) {
        switch (tm.getKind()) {
            case TYPEVAR: {
                typeVars.add((TypeVariable)tm);
                break;
            }
            case DECLARED: {
                DeclaredType type = (DeclaredType)tm;
                for (TypeMirror typeMirror : type.getTypeArguments()) {
                    Utilities.containedTypevarsRecursively(typeMirror, typeVars);
                }
                break;
            }
            case ARRAY: {
                Utilities.containedTypevarsRecursively(((ArrayType)tm).getComponentType(), typeVars);
                break;
            }
            case WILDCARD: {
                if (((WildcardType)tm).getExtendsBound() != null) {
                    Utilities.containedTypevarsRecursively(((WildcardType)tm).getExtendsBound(), typeVars);
                }
                if (((WildcardType)tm).getSuperBound() == null) break;
                Utilities.containedTypevarsRecursively(((WildcardType)tm).getSuperBound(), typeVars);
            }
        }
    }

    public static boolean allTypeVarsAccessible(Collection<TypeVariable> typeVars, Element target) {
        if (target == null) {
            return typeVars.isEmpty();
        }
        HashSet<TypeVariable> targetTypeVars = new HashSet<TypeVariable>();
        block4: while (target.getKind() != ElementKind.PACKAGE) {
            List<? extends TypeParameterElement> tpes;
            switch (target.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    tpes = ((TypeElement)target).getTypeParameters();
                    break;
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    tpes = ((ExecutableElement)target).getTypeParameters();
                    break;
                }
                default: {
                    break block4;
                }
            }
            for (TypeParameterElement typeParameterElement : tpes) {
                targetTypeVars.add((TypeVariable)typeParameterElement.asType());
            }
            if (target.getModifiers().contains((Object)Modifier.STATIC)) break;
            target = target.getEnclosingElement();
        }
        return targetTypeVars.containsAll(typeVars);
    }

    public static String target2String(TypeElement target) {
        Name qualifiedName = target.getQualifiedName();
        if (qualifiedName == null) {
            Logger.getLogger(Utilities.class.getName()).warning("Target qualified name could not be resolved.");
            return "";
        }
        String qnString = qualifiedName.toString();
        if (qnString.length() == 0) {
            qnString = ((Object)target.asType()).toString();
        }
        try {
            qnString = XMLUtil.toElementContent((String)qnString);
        }
        catch (CharConversionException ex) {
            Logger.getLogger(Utilities.class.getName()).log(Level.FINE, null, ex);
        }
        return qnString;
    }

    static {
        operator2DN.put(Tree.Kind.AND, "&");
        operator2DN.put(Tree.Kind.XOR, "^");
        operator2DN.put(Tree.Kind.OR, "|");
        operator2DN.put(Tree.Kind.CONDITIONAL_AND, "&&");
        operator2DN.put(Tree.Kind.CONDITIONAL_OR, "||");
        operator2DN.put(Tree.Kind.MULTIPLY_ASSIGNMENT, "*=");
        operator2DN.put(Tree.Kind.DIVIDE_ASSIGNMENT, "/=");
        operator2DN.put(Tree.Kind.REMAINDER_ASSIGNMENT, "%=");
        operator2DN.put(Tree.Kind.PLUS_ASSIGNMENT, "+=");
        operator2DN.put(Tree.Kind.MINUS_ASSIGNMENT, "-=");
        operator2DN.put(Tree.Kind.LEFT_SHIFT_ASSIGNMENT, "<<=");
        operator2DN.put(Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, ">>=");
        operator2DN.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, ">>>=");
        operator2DN.put(Tree.Kind.AND_ASSIGNMENT, "&=");
        operator2DN.put(Tree.Kind.XOR_ASSIGNMENT, "^=");
        operator2DN.put(Tree.Kind.OR_ASSIGNMENT, "|=");
        operator2DN.put(Tree.Kind.BITWISE_COMPLEMENT, "~");
        operator2DN.put(Tree.Kind.LOGICAL_COMPLEMENT, "!");
        operator2DN.put(Tree.Kind.MULTIPLY, "*");
        operator2DN.put(Tree.Kind.DIVIDE, "/");
        operator2DN.put(Tree.Kind.REMAINDER, "%");
        operator2DN.put(Tree.Kind.PLUS, "+");
        operator2DN.put(Tree.Kind.MINUS, "-");
        operator2DN.put(Tree.Kind.LEFT_SHIFT, "<<");
        operator2DN.put(Tree.Kind.RIGHT_SHIFT, ">>");
        operator2DN.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT, ">>>");
        operator2DN.put(Tree.Kind.LESS_THAN, "<");
        operator2DN.put(Tree.Kind.GREATER_THAN, ">");
        operator2DN.put(Tree.Kind.LESS_THAN_EQUAL, "<=");
        operator2DN.put(Tree.Kind.GREATER_THAN_EQUAL, ">=");
        operator2DN.put(Tree.Kind.EQUAL_TO, "==");
        operator2DN.put(Tree.Kind.NOT_EQUAL_TO, "!=");
    }

    private static final class ExitsFromAllBranches
    extends TreePathScanner<Boolean, Void> {
        private CompilationInfo info;
        private final Set<Tree> seenTrees = new HashSet<Tree>();
        private final Stack<Set<TypeMirror>> caughtExceptions = new Stack();

        public ExitsFromAllBranches(CompilationInfo info) {
            this.info = info;
        }

        @Override
        public Boolean scan(Tree tree, Void p) {
            this.seenTrees.add(tree);
            return (Boolean)super.scan(tree, p);
        }

        @Override
        public Boolean visitIf(IfTree node, Void p) {
            return this.scan((Tree)node.getThenStatement(), null) == Boolean.TRUE && this.scan((Tree)node.getElseStatement(), null) == Boolean.TRUE;
        }

        @Override
        public Boolean visitReturn(ReturnTree node, Void p) {
            return true;
        }

        @Override
        public Boolean visitBreak(BreakTree node, Void p) {
            return !this.seenTrees.contains(this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()));
        }

        @Override
        public Boolean visitContinue(ContinueTree node, Void p) {
            return !this.seenTrees.contains(this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()));
        }

        @Override
        public Boolean visitClass(ClassTree node, Void p) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitTry(TryTree node, Void p) {
            HashSet<TypeMirror> caught = new HashSet<TypeMirror>();
            for (CatchTree catchTree : node.getCatches()) {
                TypeMirror t = this.info.getTrees().getTypeMirror(new TreePath(new TreePath(this.getCurrentPath(), catchTree), catchTree.getParameter()));
                if (t == null) continue;
                caught.add(t);
            }
            this.caughtExceptions.push(caught);
            try {
                Boolean bl = this.scan((Tree)node.getBlock(), p) == Boolean.TRUE || this.scan((Tree)node.getFinallyBlock(), p) == Boolean.TRUE;
                return bl;
            }
            finally {
                this.caughtExceptions.pop();
            }
        }

        @Override
        public Boolean visitThrow(ThrowTree node, Void p) {
            TypeMirror type = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getExpression()));
            boolean isCaught = false;
            block0: for (Set set : this.caughtExceptions) {
                for (TypeMirror c : set) {
                    if (!this.info.getTypes().isSubtype(type, c)) continue;
                    isCaught = true;
                    break block0;
                }
            }
            return super.visitThrow(node, p) == Boolean.TRUE || !isCaught;
        }
    }

    private static class HintDisplayNameVisitor
    extends TreeScanner<String, Void> {
        private CompilationInfo info;

        public HintDisplayNameVisitor(CompilationInfo info) {
            this.info = info;
        }

        @Override
        public String visitIdentifier(IdentifierTree tree, Void v) {
            return "..." + tree.getName().toString();
        }

        @Override
        public String visitMethodInvocation(MethodInvocationTree tree, Void v) {
            ExpressionTree methodSelect = tree.getMethodSelect();
            return "..." + this.simpleName(methodSelect) + "(...)";
        }

        @Override
        public String visitArrayAccess(ArrayAccessTree node, Void p) {
            return "..." + this.simpleName(node.getExpression()) + "[]";
        }

        @Override
        public String visitNewClass(NewClassTree nct, Void p) {
            return "...new " + this.simpleName(nct.getIdentifier()) + "(...)";
        }

        @Override
        public String visitBinary(BinaryTree node, Void p) {
            String dn = (String)operator2DN.get((Object)node.getKind());
            return (String)this.scan(node.getLeftOperand(), p) + dn + (String)this.scan(node.getRightOperand(), p);
        }

        @Override
        public String visitLiteral(LiteralTree node, Void p) {
            if (node.getValue() instanceof String) {
                return "...";
            }
            int start = (int)this.info.getTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), node);
            int end = (int)this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), node);
            return this.info.getText().substring(start, end);
        }

        private String simpleName(Tree t) {
            if (t.getKind() == Tree.Kind.IDENTIFIER) {
                return ((IdentifierTree)t).getName().toString();
            }
            if (t.getKind() == Tree.Kind.MEMBER_SELECT) {
                return ((MemberSelectTree)t).getIdentifier().toString();
            }
            if (t.getKind() == Tree.Kind.METHOD_INVOCATION) {
                return (String)this.scan(t, null);
            }
            if (t.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                return this.simpleName(((ParameterizedTypeTree)t).getType()) + "<...>";
            }
            if (t.getKind() == Tree.Kind.ARRAY_ACCESS) {
                return this.simpleName(((ArrayAccessTree)t).getExpression()) + "[]";
            }
            if (t.getKind() == Tree.Kind.PARENTHESIZED) {
                return "(" + this.simpleName(((ParenthesizedTree)t).getExpression()) + ")";
            }
            if (t.getKind() == Tree.Kind.TYPE_CAST) {
                return this.simpleName(((TypeCastTree)t).getType());
            }
            if (t.getKind() == Tree.Kind.ARRAY_TYPE) {
                return this.simpleName(((ArrayTypeTree)t).getType());
            }
            throw new IllegalStateException("Currently unsupported kind of tree: " + (Object)((Object)t.getKind()));
        }
    }

    private static final class VariablesFilter
    implements ElementUtilities.ElementAcceptor {
        private static final Set<ElementKind> ACCEPTABLE_KINDS = EnumSet.of(ElementKind.ENUM_CONSTANT, ElementKind.EXCEPTION_PARAMETER, ElementKind.FIELD, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);

        private VariablesFilter() {
        }

        public boolean accept(Element e, TypeMirror type) {
            return ACCEPTABLE_KINDS.contains((Object)e.getKind());
        }
    }
}

