/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.finalize;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.finalize.Util;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class FinalizeNotProtected {
    public static ErrorDescription hint(HintContext ctx) {
        Set<Modifier> modifiers;
        assert (ctx != null);
        TreePath tp = ctx.getPath();
        MethodTree tree = (MethodTree)tp.getLeaf();
        if (Util.isFinalize(tree) && (modifiers = tree.getModifiers().getFlags()).contains((Object)Modifier.PUBLIC)) {
            return ErrorDescriptionFactory.forName(ctx, tp, NbBundle.getMessage(FinalizeNotProtected.class, (String)"TXT_FinalizeNotProtected"), new FixImpl(TreePathHandle.create((TreePath)tp, (CompilationInfo)ctx.getInfo())), FixFactory.createSuppressWarningsFix(ctx.getInfo(), ctx.getPath(), "FinalizeNotProtected"));
        }
        return null;
    }

    static class FixImpl
    implements Fix {
        private final TreePathHandle handle;

        FixImpl(TreePathHandle handle) {
            assert (handle != null);
            this.handle = handle;
        }

        public String getText() {
            return NbBundle.getMessage(FinalizeNotProtected.class, (String)"FIX_FinalizeNotProtected_MakePublic");
        }

        public ChangeInfo implement() throws Exception {
            JavaSource.forFileObject((FileObject)this.handle.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath tp = FixImpl.this.handle.resolve((CompilationInfo)wc);
                    if (tp == null) {
                        return;
                    }
                    Tree tree = tp.getLeaf();
                    if (tree.getKind() != Tree.Kind.METHOD) {
                        return;
                    }
                    TreeMaker tm = wc.getTreeMaker();
                    wc.rewrite((Tree)((MethodTree)tree).getModifiers(), (Tree)tm.addModifiersModifier(tm.removeModifiersModifier(((MethodTree)tree).getModifiers(), Modifier.PUBLIC), Modifier.PROTECTED));
                }
            }).commit();
            return null;
        }
    }
}

