/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.EOFException;
import java.io.IOException;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.ByteArray;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class MessageResponse
implements Response {
    private boolean terminating = false;
    private String firstWord;

    public MessageResponse() {
    }

    public MessageResponse(String initialWord) {
        this.firstWord = initialWord;
    }

    public void process(LoggedDataInputStream dis, ResponseServices services) throws ResponseException {
        try {
            ByteArray bytes = dis.readLineBytes();
            String line = bytes.getStringFromBytes();
            if (this.firstWord != null) {
                line = this.firstWord + " " + line;
            }
            this.terminating |= line.endsWith(" [server aborted]: received termination signal");
            this.terminating |= line.endsWith(" [server aborted]: received broken pipe signal");
            this.terminating |= line.endsWith(" [checkout aborted]: end of file from server (consult above messages if any)");
            this.terminating &= dis.available() == 0;
            MessageEvent event = new MessageEvent(this, line, bytes.getBytes(), false);
            services.getEventManager().fireCVSEvent(event);
        }
        catch (EOFException ex) {
            throw new ResponseException(ex, ResponseException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException ex) {
            throw new ResponseException(ex);
        }
    }

    public boolean isTerminalResponse() {
        return this.terminating;
    }
}

