/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.refactoring;

import java.awt.Cursor;
import java.awt.Frame;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.refactoring.ExtractInlinedStyleRefactoringUI;
import org.netbeans.modules.html.editor.refactoring.HtmlSpecificActionsImplementationProvider;
import org.netbeans.modules.html.editor.refactoring.RefactoringContext;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class HtmlSpecificRefactoringsProvider
extends HtmlSpecificActionsImplementationProvider {
    @Override
    public boolean canExtractInlineStyle(Lookup lookup) {
        OffsetRange adjusted;
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (ec == null) {
            return false;
        }
        JEditorPane pane = NbDocument.findRecentEditorPane((EditorCookie)ec);
        if (pane == null) {
            return false;
        }
        StyledDocument doc = ec.getDocument();
        return !RefactoringContext.findInlinedStyles(doc, (adjusted = HtmlSpecificRefactoringsProvider.adjustContextRange(doc, pane.getSelectionStart(), pane.getSelectionEnd())).getStart(), adjusted.getEnd()).isEmpty();
    }

    @Override
    public void doExtractInlineStyle(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (ec == null) {
            return;
        }
        JEditorPane[] panes = ec.getOpenedPanes();
        if (panes == null || panes.length == 0) {
            return;
        }
        JEditorPane pane = panes[0];
        if (pane == null) {
            return;
        }
        final StyledDocument doc = ec.getDocument();
        final FileObject file = DataLoadersBridge.getDefault().getFileObject((Document)doc);
        assert (file != null);
        final OffsetRange adjusted = HtmlSpecificRefactoringsProvider.adjustContextRange(doc, pane.getSelectionStart(), pane.getSelectionEnd());
        final Frame main = WindowManager.getDefault().getMainWindow();
        final Runnable setDefaultCursorTask = new Runnable(){

            @Override
            public void run() {
                main.setCursor(null);
            }
        };
        main.setCursor(Cursor.getPredefinedCursor(3));
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    final RefactoringContext context = RefactoringContext.create(file, doc, adjusted.getStart(), adjusted.getEnd());
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                UI.openRefactoringUI((RefactoringUI)new ExtractInlinedStyleRefactoringUI(context));
                            }
                            finally {
                                setDefaultCursorTask.run();
                            }
                        }
                    });
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (Throwable t) {
                    SwingUtilities.invokeLater(setDefaultCursorTask);
                }
            }
        });
    }

    private static OffsetRange adjustContextRange(final Document doc, final int from, final int to) {
        final AtomicReference<OffsetRange> ret = new AtomicReference<OffsetRange>();
        ret.set(new OffsetRange(from, to));
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence(doc, from);
                if (ts == null) {
                    return;
                }
                Token<HTMLTokenId> openTag = Utils.findTagOpenToken(ts);
                if (openTag == null) {
                    return;
                }
                int adjustedFrom = ts.offset();
                ts.move(to);
                int adjustedTo = -1;
                while (ts.moveNext()) {
                    Token t = ts.token();
                    if (t.id() == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                        adjustedTo = ts.offset() + t.length();
                        break;
                    }
                    if (t.id() != HTMLTokenId.TEXT) continue;
                    break;
                }
                if (adjustedTo == -1) {
                    return;
                }
                ret.set(new OffsetRange(adjustedFrom, adjustedTo));
            }
        });
        return (OffsetRange)ret.get();
    }
}

