/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.DeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.SpecializationDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.openide.util.CharSequences;

public class ClassImplSpecialization
extends ClassImpl
implements CsmTemplate {
    private CharSequence qualifiedNameSuffix = CharSequences.empty();
    private SpecializationDescriptor specializationDesctiptor;

    protected ClassImplSpecialization(AST aST, NameHolder nameHolder, CsmFile csmFile) {
        super(nameHolder, aST, csmFile);
    }

    protected ClassImplSpecialization(AST aST, NameHolder nameHolder, CsmFile csmFile, int n, int n2) {
        super(nameHolder, aST, csmFile, n, n2);
    }

    @Override
    protected final void init(CsmScope csmScope, AST aST, boolean bl) {
        this.initScope(csmScope);
        ClassImplSpecialization.temporaryRepositoryRegistration(bl, this);
        this.render(aST, !bl);
        this.initQualifiedName(aST, csmScope, bl);
        if (bl) {
            this.register(this.getScope(), false);
        }
    }

    protected final void initQualifiedName(AST aST, CsmScope csmScope, boolean bl) {
        AST aST2 = AstUtil.findChildOfType(aST, 503);
        assert (aST2 != null);
        this.qualifiedNameSuffix = NameCache.getManager().getString((CharSequence)TemplateUtils.getSpecializationSuffix(aST2, this.getTemplateParameters()));
        this.initQualifiedName(csmScope);
        this.specializationDesctiptor = SpecializationDescriptor.createIfNeeded(aST, this.getContainingFile(), csmScope, bl);
    }

    public static ClassImplSpecialization create(AST aST, CsmScope csmScope, CsmFile csmFile, boolean bl, DeclarationsContainer declarationsContainer) {
        ClassImpl classImpl = ClassImplSpecialization.findExistingClassImplInContainer(declarationsContainer, aST);
        ClassImplSpecialization classImplSpecialization = null;
        if (classImpl instanceof ClassImplSpecialization) {
            classImplSpecialization = (ClassImplSpecialization)classImpl;
        }
        NameHolder nameHolder = null;
        if (classImplSpecialization == null) {
            nameHolder = NameHolder.createClassName(aST);
            classImplSpecialization = new ClassImplSpecialization(aST, nameHolder, csmFile);
        }
        classImplSpecialization.init(csmScope, aST, bl);
        if (nameHolder != null) {
            nameHolder.addReference(csmFile, classImplSpecialization);
        }
        return classImplSpecialization;
    }

    @Override
    public boolean isTemplate() {
        return true;
    }

    @Override
    public boolean isSpecialization() {
        return true;
    }

    @Override
    public boolean isExplicitSpecialization() {
        return false;
    }

    @Override
    public String getQualifiedNamePostfix() {
        return super.getQualifiedNamePostfix() + ((Object)this.qualifiedNameSuffix).toString();
    }

    protected String getQualifiedNameWithoutSuffix() {
        CsmScope csmScope = this.getScope();
        String string = ((Object)this.getName()).toString();
        if (CsmKindUtilities.isNamespace((Object)csmScope)) {
            return Utils.getQualifiedName(string, (CsmNamespace)csmScope);
        }
        if (CsmKindUtilities.isClass((CsmObject)csmScope)) {
            String string2 = string;
            if (string.contains("::")) {
                string = string.substring(string.lastIndexOf("::") + 2);
            }
            return ((CsmClass)csmScope).getQualifiedName() + "::" + string;
        }
        return string;
    }

    public List<CsmSpecializationParameter> getSpecializationParameters() {
        return this.specializationDesctiptor != null ? this.specializationDesctiptor.getSpecializationParameters() : Collections.emptyList();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeUTF(this.qualifiedNameSuffix, dataOutput);
        PersistentUtils.writeSpecializationDescriptor(this.specializationDesctiptor, dataOutput);
    }

    public ClassImplSpecialization(DataInput dataInput) throws IOException {
        super(dataInput);
        this.qualifiedNameSuffix = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        this.specializationDesctiptor = PersistentUtils.readSpecializationDescriptor(dataInput);
    }

    @Override
    public String getDisplayName() {
        return this.getName() + ((Object)this.qualifiedNameSuffix).toString();
    }
}

