/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

public final class FriendFunctionImpl
extends FunctionImpl<CsmFriendFunction>
implements CsmFriendFunction {
    private final CsmUID<CsmClass> friendClassUID;

    private FriendFunctionImpl(AST aST, ClassImpl classImpl, CsmScope csmScope, NameHolder nameHolder, boolean bl) throws AstRendererException {
        super(aST, classImpl.getContainingFile(), null, csmScope, nameHolder, bl);
        this.friendClassUID = classImpl.getUID();
    }

    public static FriendFunctionImpl create(AST aST, ClassImpl classImpl, CsmScope csmScope, boolean bl) throws AstRendererException {
        NameHolder nameHolder = NameHolder.createFunctionName(aST);
        FriendFunctionImpl friendFunctionImpl = new FriendFunctionImpl(aST, classImpl, csmScope, nameHolder, bl);
        FriendFunctionImpl.postObjectCreateRegistration(bl, friendFunctionImpl);
        nameHolder.addReference(classImpl.getContainingFile(), friendFunctionImpl);
        return friendFunctionImpl;
    }

    public CsmFunction getReferencedFunction() {
        FriendFunctionImpl friendFunctionImpl = this;
        if (CsmKindUtilities.isFunctionDeclaration((CsmObject)this) && (friendFunctionImpl = this.getDefinition()) == null) {
            friendFunctionImpl = this;
        }
        return friendFunctionImpl;
    }

    public CsmClass getContainingClass() {
        CsmClass csmClass = null;
        csmClass = UIDCsmConverter.UIDtoClass(this.friendClassUID);
        assert (this.friendClassUID != null) : "null object for UID " + this.friendClassUID;
        return csmClass;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_FRIEND;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.friendClassUID, dataOutput);
    }

    public FriendFunctionImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.friendClassUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

