/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMacroParameter;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.utils.cache.TextCache;
import org.openide.util.CharSequences;

public final class SystemMacroImpl
implements CsmMacro,
CsmIdentifiable {
    private final CharSequence macroName;
    private final CharSequence macroBody;
    private final CsmMacro.Kind macroKind;
    private final List<CharSequence> params;
    private final CsmFile containingFile;
    private final CsmUID<CsmMacro> uid;

    private SystemMacroImpl(CharSequence charSequence, String string, List<CharSequence> list, CsmFile csmFile, CsmMacro.Kind kind) {
        this.macroName = NameCache.getManager().getString(charSequence);
        this.macroBody = TextCache.getManager().getString((CharSequence)string);
        this.macroKind = kind;
        this.params = list != null ? Collections.unmodifiableList(list) : null;
        assert (csmFile instanceof Unresolved.UnresolvedFile);
        this.containingFile = csmFile;
        this.uid = UIDProviderIml.createSelfUID(this);
    }

    public static SystemMacroImpl create(CharSequence charSequence, String string, List<CharSequence> list, CsmFile csmFile, CsmMacro.Kind kind) {
        return new SystemMacroImpl(charSequence, string, list, csmFile, kind);
    }

    public List<CharSequence> getParameters() {
        return this.params;
    }

    public CharSequence getBody() {
        return this.macroBody;
    }

    public CsmMacro.Kind getKind() {
        return this.macroKind;
    }

    public CharSequence getName() {
        return this.macroName;
    }

    public CsmFile getContainingFile() {
        return this.containingFile;
    }

    public int getStartOffset() {
        return 0;
    }

    public int getEndOffset() {
        return 0;
    }

    public CsmOffsetable.Position getStartPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CsmOffsetable.Position getEndPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CharSequence getText() {
        return "#define " + this.macroName + " " + this.macroBody;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == null || !(object instanceof SystemMacroImpl)) {
            bl = false;
        } else {
            SystemMacroImpl systemMacroImpl = (SystemMacroImpl)object;
            bl = CharSequences.comparator().compare(this.getName(), systemMacroImpl.getName()) == 0;
        }
        return bl;
    }

    public int hashCode() {
        int n = 7;
        n = 79 * n + (this.macroName != null ? this.macroName.hashCode() : 0);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#define '");
        stringBuilder.append(this.getName());
        if (this.getParameters() != null) {
            stringBuilder.append("[");
            Iterator<CharSequence> iterator = this.getParameters().iterator();
            while (iterator.hasNext()) {
                CharSequence charSequence = iterator.next();
                stringBuilder.append(charSequence);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
        }
        if (this.getBody().length() > 0) {
            stringBuilder.append("'='");
            stringBuilder.append(this.getBody());
        }
        stringBuilder.append("' [").append(this.macroKind == CsmMacro.Kind.USER_SPECIFIED ? "user defined" : "system").append("]");
        return stringBuilder.toString();
    }

    public CsmParameterList<CsmMacroParameter> getParameterList() {
        return null;
    }

    @Override
    public CsmUID<?> getUID() {
        return this.uid;
    }
}

