/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import org.netbeans.modules.cnd.modelimpl.csm.core.AbstractFileBuffer;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.openide.filesystems.FileObject;

public class FileBufferFile
extends AbstractFileBuffer {
    private volatile SoftReference<char[]> cachedArray;
    private volatile long lastModifiedWhenCachedString;

    public FileBufferFile(FileObject fileObject) {
        super(fileObject);
    }

    @Override
    public CharSequence getText() throws IOException {
        char[] cArray = this.doGetChar();
        return new MyCharSequence(cArray);
    }

    @Override
    public String getText(int n, int n2) {
        try {
            char[] cArray = this.doGetChar();
            if (n2 > cArray.length) {
                new IllegalArgumentException("").printStackTrace(System.err);
                n2 = cArray.length;
            }
            return new String(cArray, n, n2 - n);
        }
        catch (IOException iOException) {
            DiagnosticExceptoins.register(iOException);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized char[] doGetChar() throws IOException {
        Object object;
        SoftReference<char[]> softReference = this.cachedArray;
        if (softReference != null && (object = (Object)softReference.get()) != null && this.lastModifiedWhenCachedString == this.lastModified()) {
            return object;
        }
        object = this.getFileObject();
        long l = object.getSize();
        if (l > Integer.MAX_VALUE) {
            new IllegalArgumentException("File is too large: " + object.getPath()).printStackTrace(System.err);
        }
        if (l == 0L) {
            return new char[0];
        }
        char[] cArray = new char[(int)l + 1];
        InputStream inputStream = this.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.getEncoding()));
        try {
            String string;
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                for (int i = 0; i < string.length(); ++i) {
                    cArray[n++] = string.charAt(i);
                }
                cArray[n++] = 10;
            }
            if (cArray.length > n) {
                char[] cArray2 = new char[n];
                System.arraycopy(cArray, 0, cArray2, 0, n);
                cArray = cArray2;
            }
        }
        finally {
            bufferedReader.close();
            inputStream.close();
        }
        this.cachedArray = new SoftReference<char[]>(cArray);
        this.lastModifiedWhenCachedString = this.lastModified();
        return cArray;
    }

    private InputStream getInputStream() throws IOException {
        FileObject fileObject = this.getFileObject();
        if (fileObject == null || !fileObject.isValid()) {
            throw new FileNotFoundException("Null file object for " + this.getAbsolutePath());
        }
        InputStream inputStream = fileObject.getInputStream();
        return new BufferedInputStream(inputStream, TraceFlags.BUF_SIZE);
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public long lastModified() {
        return this.getFileObject().lastModified().getTime();
    }

    public FileBufferFile(DataInput dataInput) throws IOException {
        super(dataInput);
    }

    public char[] getCharBuffer() throws IOException {
        return this.doGetChar();
    }

    private static final class MyCharSequence
    implements CharSequence {
        private final char[] buf;
        private final int start;
        private final int end;

        private MyCharSequence(char[] cArray) {
            this(cArray, 0, cArray.length);
        }

        private MyCharSequence(char[] cArray, int n, int n2) {
            this.buf = cArray;
            this.start = n;
            this.end = n2;
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int n) {
            return this.buf[this.start + n];
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return new MyCharSequence(this.buf, n, n2);
        }
    }
}

