/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.FileInstantiationsKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class FileComponentInstantiations
extends FileComponent
implements Persistent,
SelfPersistent {
    private Set<CsmUID<CsmInstantiation>> instantiations = this.createInstantiations();
    private final ReadWriteLock instantiationsLock = new ReentrantReadWriteLock();
    private static final FileComponentInstantiations EMPTY = new FileComponentInstantiations(){

        @Override
        public void put() {
        }
    };
    private static final Comparator<CsmUID<?>> UID_START_OFFSET_COMPARATOR = new Comparator<CsmUID<?>>(){

        @Override
        public int compare(CsmUID<?> csmUID, CsmUID<?> csmUID2) {
            if (csmUID == csmUID2) {
                return 0;
            }
            Comparable comparable = (Comparable)csmUID;
            assert (comparable != null);
            return comparable.compareTo(csmUID2);
        }
    };

    public static FileComponentInstantiations empty() {
        return EMPTY;
    }

    public FileComponentInstantiations(FileImpl fileImpl) {
        super(new FileInstantiationsKey(fileImpl));
        this.put();
    }

    public FileComponentInstantiations(DataInput dataInput) throws IOException {
        super(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        uIDObjectFactory.readUIDCollection(this.instantiations, dataInput);
    }

    private FileComponentInstantiations() {
        super((Key)null);
    }

    void clean() {
        this._clearInstantiations();
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearInstantiations() {
        try {
            this.instantiationsLock.writeLock().lock();
            RepositoryUtils.remove(this.instantiations);
            this.instantiations = this.createInstantiations();
        }
        finally {
            this.instantiationsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInstantiation(CsmInstantiation csmInstantiation) {
        CsmUID<CsmInstantiation> csmUID = RepositoryUtils.put(csmInstantiation);
        assert (csmUID != null);
        try {
            this.instantiationsLock.writeLock().lock();
            this.instantiations.add(csmUID);
        }
        finally {
            this.instantiationsLock.writeLock().unlock();
        }
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmInstantiation> getInstantiations() {
        Collection<CsmInstantiation> collection;
        try {
            this.instantiationsLock.readLock().lock();
            collection = UIDCsmConverter.UIDsToInstantiations(this.instantiations);
        }
        finally {
            this.instantiationsLock.readLock().unlock();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<CsmInstantiation> getInstantiations(CsmSelect.CsmFilter csmFilter) {
        Iterator<CsmInstantiation> iterator;
        try {
            this.instantiationsLock.readLock().lock();
            iterator = UIDCsmConverter.UIDsToInstantiations(this.instantiations, csmFilter);
        }
        finally {
            this.instantiationsLock.readLock().unlock();
        }
        return iterator;
    }

    private Set<CsmUID<CsmInstantiation>> createInstantiations() {
        return new TreeSet<CsmUID<CsmInstantiation>>(UID_START_OFFSET_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        try {
            this.instantiationsLock.readLock().lock();
            uIDObjectFactory.writeUIDCollection(this.instantiations, dataOutput, false);
        }
        finally {
            this.instantiationsLock.readLock().unlock();
        }
    }
}

