/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.FileMacrosKey;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.DefaultCache;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.openide.util.CharSequences;

public class FileComponentMacros
extends FileComponent
implements Persistent,
SelfPersistent {
    private final TreeMap<NameSortedKey, CsmUID<CsmMacro>> macros;
    private final ReadWriteLock macrosLock = new ReentrantReadWriteLock();
    private static final FileComponentMacros EMPTY = new FileComponentMacros(){

        @Override
        public void put() {
        }
    };

    public static FileComponentMacros empty() {
        return EMPTY;
    }

    public FileComponentMacros(FileImpl fileImpl) {
        super(new FileMacrosKey(fileImpl));
        this.macros = this.createMacros();
        this.put();
    }

    public FileComponentMacros(DataInput dataInput) throws IOException {
        super(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.macros = uIDObjectFactory.readNameSortedToUIDMap(dataInput, DefaultCache.getManager());
    }

    private FileComponentMacros() {
        super((Key)null);
        this.macros = this.createMacros();
    }

    void clean() {
        this._clearMacros();
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearMacros() {
        ArrayList<CsmUID<CsmMacro>> arrayList;
        try {
            this.macrosLock.writeLock().lock();
            arrayList = new ArrayList<CsmUID<CsmMacro>>(this.macros.values());
            this.macros.clear();
        }
        finally {
            this.macrosLock.writeLock().unlock();
        }
        RepositoryUtils.remove(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMacro(CsmMacro csmMacro) {
        CsmUID<CsmMacro> csmUID = RepositoryUtils.put(csmMacro);
        NameSortedKey nameSortedKey = new NameSortedKey(csmMacro);
        assert (csmUID != null);
        try {
            this.macrosLock.writeLock().lock();
            this.macros.put(nameSortedKey, csmUID);
        }
        finally {
            this.macrosLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmMacro> getMacros() {
        Collection<CsmMacro> collection;
        try {
            this.macrosLock.readLock().lock();
            collection = UIDCsmConverter.UIDsToMacros(this.macros.values());
        }
        finally {
            this.macrosLock.readLock().unlock();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<CsmMacro> getMacros(CsmSelect.CsmFilter csmFilter) {
        Iterator<CsmMacro> iterator;
        try {
            this.macrosLock.readLock().lock();
            iterator = UIDCsmConverter.UIDsToMacros(this.macros.values(), csmFilter);
        }
        finally {
            this.macrosLock.readLock().unlock();
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmUID<CsmMacro>> findMacroUids(CharSequence charSequence) {
        ArrayList<CsmUID<CsmMacro>> arrayList = new ArrayList<CsmUID<CsmMacro>>(2);
        NameSortedKey nameSortedKey = NameSortedKey.getStartKey(charSequence);
        NameSortedKey nameSortedKey2 = NameSortedKey.getEndKey(charSequence);
        try {
            this.macrosLock.readLock().lock();
            for (Map.Entry<NameSortedKey, CsmUID<CsmMacro>> entry : this.macros.subMap(nameSortedKey, nameSortedKey2).entrySet()) {
                arrayList.add(entry.getValue());
            }
        }
        finally {
            this.macrosLock.readLock().unlock();
        }
        return arrayList;
    }

    private TreeMap<NameSortedKey, CsmUID<CsmMacro>> createMacros() {
        return new TreeMap<NameSortedKey, CsmUID<CsmMacro>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        try {
            this.macrosLock.readLock().lock();
            uIDObjectFactory.writeNameSortedToUIDMap(this.macros, dataOutput, false);
        }
        finally {
            this.macrosLock.readLock().unlock();
        }
    }

    public static class NameSortedKey
    implements Comparable<NameSortedKey>,
    Persistent,
    SelfPersistent {
        private int start = 0;
        private CharSequence name;

        private NameSortedKey(CsmMacro csmMacro) {
            this(csmMacro.getName(), csmMacro.getStartOffset());
        }

        private NameSortedKey(CharSequence charSequence, int n) {
            this.start = n;
            this.name = NameCache.getManager().getString(charSequence);
        }

        @Override
        public int compareTo(NameSortedKey nameSortedKey) {
            int n = CharSequences.comparator().compare(this.name, nameSortedKey.name);
            if (n == 0) {
                n = this.start - nameSortedKey.start;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof NameSortedKey) {
                NameSortedKey nameSortedKey = (NameSortedKey)object;
                return this.compareTo(nameSortedKey) == 0;
            }
            return false;
        }

        public int hashCode() {
            int n = 7;
            n = 37 * n + this.start;
            n = 37 * n + (this.name != null ? this.name.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "NameSortedKey: " + this.name + "[" + this.start;
        }

        public static NameSortedKey getStartKey(CharSequence charSequence) {
            return new NameSortedKey(charSequence, 0);
        }

        public static NameSortedKey getEndKey(CharSequence charSequence) {
            return new NameSortedKey(charSequence, Integer.MAX_VALUE);
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.start);
            PersistentUtils.writeUTF(this.name, dataOutput);
        }

        public NameSortedKey(DataInput dataInput) throws IOException {
            this.start = dataInput.readInt();
            this.name = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        }
    }
}

