/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.SourceRootContainer;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileSystem;

public final class LibProjectImpl
extends ProjectBase {
    private final CharSequence includePath;
    private final SourceRootContainer projectRoots = new SourceRootContainer(true);

    private LibProjectImpl(ModelImpl modelImpl, FileSystem fileSystem, String string) {
        super(modelImpl, fileSystem, string, string);
        this.includePath = FilePathCache.getManager().getString((CharSequence)string);
        this.projectRoots.fixFolder(string);
        assert (this.includePath != null);
    }

    public static LibProjectImpl createInstance(ModelImpl modelImpl, FileSystem fileSystem, String string) {
        ProjectBase projectBase = null;
        assert (string != null);
        if (TraceFlags.PERSISTENT_REPOSITORY) {
            try {
                projectBase = LibProjectImpl.readInstance(modelImpl, fileSystem, string, string);
            }
            catch (Exception exception) {
                LibProjectImpl.cleanRepository(fileSystem, string, true);
                DiagnosticExceptoins.register(exception);
            }
        }
        if (projectBase == null) {
            projectBase = new LibProjectImpl(modelImpl, fileSystem, string);
        }
        if (projectBase instanceof LibProjectImpl) assert (((LibProjectImpl)projectBase).includePath != null);
        CndUtils.assertTrue((projectBase.getFileSystem() == fileSystem ? 1 : 0) != 0);
        return (LibProjectImpl)projectBase;
    }

    protected CharSequence getPath() {
        return this.includePath;
    }

    @Override
    protected void ensureFilesCreated() {
    }

    protected boolean isStableStatus() {
        return true;
    }

    @Override
    protected Collection<Key> getLibrariesKeys() {
        return Collections.emptySet();
    }

    @Override
    public List<CsmProject> getLibraries() {
        return Collections.emptyList();
    }

    @Override
    public void onFileRemoved(List<NativeFileItem> list) {
    }

    @Override
    public void onFileImplRemoved(Collection<FileImpl> collection) {
    }

    @Override
    public void onFileAdded(NativeFileItem nativeFileItem) {
    }

    @Override
    public void onFileAdded(List<NativeFileItem> list) {
    }

    @Override
    public void onFilePropertyChanged(NativeFileItem nativeFileItem) {
    }

    @Override
    public void onFilePropertyChanged(List<NativeFileItem> list) {
    }

    @Override
    protected final ParserQueue.Position getIncludedFileParserQueuePosition() {
        return ParserQueue.Position.TAIL;
    }

    public boolean isArtificial() {
        return true;
    }

    @Override
    public NativeFileItem getNativeFileItem(CsmUID<CsmFile> csmUID) {
        return null;
    }

    @Override
    protected void putNativeFileItem(CsmUID<CsmFile> csmUID, NativeFileItem nativeFileItem) {
    }

    @Override
    protected NativeFileItem removeNativeFileItem(CsmUID<CsmFile> csmUID) {
        return null;
    }

    @Override
    protected void clearNativeFileContainer() {
    }

    @Override
    public boolean isStable(CsmFile csmFile) {
        if (!this.isDisposing()) {
            return !ParserQueue.instance().hasPendingProjectRelatedWork(this, (FileImpl)csmFile);
        }
        return false;
    }

    @Override
    protected SourceRootContainer getProjectRoots() {
        return this.projectRoots;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.includePath != null);
        PersistentUtils.writeUTF(this.includePath, dataOutput);
    }

    public LibProjectImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.includePath = PersistentUtils.readUTF(dataInput, FilePathCache.getManager());
        assert (this.includePath != null);
        this.setPlatformProject(this.includePath);
    }
}

