/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.StartEntry;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.repository.spi.Key;

public class Utils {
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.modelimpl");
    private static final int LOG_LEVEL = Integer.getInteger("org.netbeans.modules.cnd.modelimpl.level", -1);

    private Utils() {
    }

    public static CsmOffsetable createOffsetable(CsmFile csmFile, int n, int n2) {
        return OffsetableBase.create(csmFile, n, n2);
    }

    public static String getQualifiedName(String string, CsmNamespace csmNamespace) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (csmNamespace != null && !csmNamespace.isGlobal()) {
            stringBuilder.insert(0, "::");
            stringBuilder.insert(0, csmNamespace.getQualifiedName());
        }
        return stringBuilder.toString();
    }

    public static CharSequence[] splitQualifiedName(String string) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ": \t\n\r\f", false);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(NameCache.getManager().getString((CharSequence)stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new CharSequence[arrayList.size()]);
    }

    public static void disposeAll(Collection<? extends CsmObject> collection) {
        for (CsmObject csmObject : collection) {
            if (csmObject instanceof Disposable) {
                Disposable disposable = (Disposable)csmObject;
                if (TraceFlags.TRACE_DISPOSE) {
                    System.err.println("disposing with UID " + ((CsmIdentifiable)csmObject).getUID());
                }
                disposable.dispose();
                continue;
            }
            if (!TraceFlags.TRACE_DISPOSE) continue;
            System.err.println("non disposable with UID " + ((CsmIdentifiable)csmObject).getUID());
        }
    }

    public static void setSelfUID(CsmObject csmObject) {
        if (!(csmObject instanceof OffsetableIdentifiableBase)) {
            throw new IllegalArgumentException("unexpected object:" + csmObject);
        }
        ((OffsetableIdentifiableBase)csmObject).setSelfUID();
    }

    public static String getCsmIncludeKindKey() {
        return "I";
    }

    public static String getCsmInheritanceKindKey(CsmInheritance csmInheritance) {
        switch (csmInheritance.getVisibility()) {
            case PRIVATE: {
                return "h";
            }
            case PROTECTED: {
                return "y";
            }
            case PUBLIC: {
                return "H";
            }
        }
        return "Y";
    }

    public static CsmVisibility getCsmVisibility(char c) {
        switch (c) {
            case 'h': {
                return CsmVisibility.PRIVATE;
            }
            case 'y': {
                return CsmVisibility.PROTECTED;
            }
            case 'H': {
                return CsmVisibility.PUBLIC;
            }
        }
        return CsmVisibility.NONE;
    }

    public static String getCsmParamListKindKey() {
        return "P";
    }

    public static String getCsmInstantiationKindKey() {
        return "i";
    }

    public static CharSequence[] getAllClassifiersUniqueNames(CharSequence charSequence) {
        CharSequence charSequence2 = charSequence.subSequence(1, charSequence.length());
        CharSequence[] charSequenceArray = new CharSequence[]{Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.CLASS) + charSequence2, Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.STRUCT) + charSequence2, Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.UNION) + charSequence2, Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.ENUM) + charSequence2, Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.TYPEDEF) + charSequence2, Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION) + charSequence2};
        return charSequenceArray;
    }

    public static String getCsmDeclarationKindkey(CsmDeclaration.Kind kind) {
        switch (kind) {
            case ASM: {
                return "A";
            }
            case BUILT_IN: {
                return "B";
            }
            case CLASS: {
                return "C";
            }
            case ENUM: {
                return "E";
            }
            case FUNCTION: {
                return "F";
            }
            case MACRO: {
                return "M";
            }
            case NAMESPACE_DEFINITION: {
                return "N";
            }
            case STRUCT: {
                return "S";
            }
            case TEMPLATE_DECLARATION: {
                return "T";
            }
            case UNION: {
                return "U";
            }
            case VARIABLE: {
                return "V";
            }
            case NAMESPACE_ALIAS: {
                return "a";
            }
            case ENUMERATOR: {
                return "e";
            }
            case FUNCTION_DEFINITION: {
                return "f";
            }
            case USING_DIRECTIVE: {
                return "g";
            }
            case TEMPLATE_PARAMETER: {
                return "p";
            }
            case CLASS_FRIEND_DECLARATION: {
                return "r";
            }
            case TEMPLATE_SPECIALIZATION: {
                return "s";
            }
            case TYPEDEF: {
                return "t";
            }
            case USING_DECLARATION: {
                return "u";
            }
            case VARIABLE_DEFINITION: {
                return "v";
            }
            case CLASS_FORWARD_DECLARATION: {
                return "w";
            }
            case FUNCTION_FRIEND: {
                return "D";
            }
            case FUNCTION_FRIEND_DEFINITION: {
                return "d";
            }
        }
        throw new IllegalArgumentException("Unexpected value of CsmDeclaration.Kind:" + kind);
    }

    public static CsmDeclaration.Kind getCsmDeclarationKind(char c) {
        switch (c) {
            case 'A': {
                return CsmDeclaration.Kind.ASM;
            }
            case 'B': {
                return CsmDeclaration.Kind.BUILT_IN;
            }
            case 'C': {
                return CsmDeclaration.Kind.CLASS;
            }
            case 'E': {
                return CsmDeclaration.Kind.ENUM;
            }
            case 'F': {
                return CsmDeclaration.Kind.FUNCTION;
            }
            case 'M': {
                return CsmDeclaration.Kind.MACRO;
            }
            case 'N': {
                return CsmDeclaration.Kind.NAMESPACE_DEFINITION;
            }
            case 'S': {
                return CsmDeclaration.Kind.STRUCT;
            }
            case 'T': {
                return CsmDeclaration.Kind.TEMPLATE_DECLARATION;
            }
            case 'U': {
                return CsmDeclaration.Kind.UNION;
            }
            case 'V': {
                return CsmDeclaration.Kind.VARIABLE;
            }
            case 'a': {
                return CsmDeclaration.Kind.NAMESPACE_ALIAS;
            }
            case 'e': {
                return CsmDeclaration.Kind.ENUMERATOR;
            }
            case 'f': {
                return CsmDeclaration.Kind.FUNCTION_DEFINITION;
            }
            case 'g': {
                return CsmDeclaration.Kind.USING_DIRECTIVE;
            }
            case 'p': {
                return CsmDeclaration.Kind.TEMPLATE_PARAMETER;
            }
            case 'r': {
                return CsmDeclaration.Kind.CLASS_FRIEND_DECLARATION;
            }
            case 's': {
                return CsmDeclaration.Kind.TEMPLATE_SPECIALIZATION;
            }
            case 't': {
                return CsmDeclaration.Kind.TYPEDEF;
            }
            case 'u': {
                return CsmDeclaration.Kind.USING_DECLARATION;
            }
            case 'v': {
                return CsmDeclaration.Kind.VARIABLE_DEFINITION;
            }
            case 'w': {
                return CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION;
            }
            case 'D': {
                return CsmDeclaration.Kind.FUNCTION_FRIEND;
            }
            case 'd': {
                return CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION;
            }
        }
        throw new IllegalArgumentException("Unexpected char for CsmDeclaration.Kind: " + c);
    }

    public static boolean canRegisterDeclaration(CsmDeclaration csmDeclaration) {
        assert (csmDeclaration != null);
        assert (csmDeclaration.getName() != null);
        if (csmDeclaration.getName().length() == 0) {
            return false;
        }
        CsmScope csmScope = csmDeclaration.getScope();
        if (csmScope instanceof CsmCompoundClassifier) {
            return Utils.canRegisterDeclaration((CsmDeclaration)((CsmCompoundClassifier)csmScope));
        }
        return true;
    }

    public static <T> LinkedList<T> reverse(LinkedList<T> linkedList) {
        LinkedList<T> linkedList2 = new LinkedList<T>();
        ListIterator<T> listIterator = linkedList.listIterator(linkedList.size());
        while (listIterator.hasPrevious()) {
            linkedList2.addLast(listIterator.previous());
        }
        return linkedList2;
    }

    public static NativeFileItem getCompiledFileItem(FileImpl fileImpl) {
        NativeFileItem nativeFileItem = null;
        ProjectBase projectBase = fileImpl.getProjectImpl(true);
        if (projectBase != null) {
            Collection<APTPreprocHandler.State> collection = projectBase.getPreprocStates(fileImpl);
            if (collection.isEmpty()) {
                return null;
            }
            APTPreprocHandler.State state = collection.iterator().next();
            FileImpl fileImpl2 = Utils.getStartFile(state);
            nativeFileItem = fileImpl2 != null ? fileImpl2.getNativeFileItem() : null;
        }
        return nativeFileItem;
    }

    public static FileImpl getStartFile(APTPreprocHandler.State state) {
        StartEntry startEntry = APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state);
        ProjectBase projectBase = Utils.getStartProject(startEntry);
        FileImpl fileImpl = projectBase == null ? null : projectBase.getFile(startEntry.getStartFile(), false);
        return fileImpl;
    }

    public static ProjectBase getStartProject(APTPreprocHandler.State state) {
        return Utils.getStartProject(APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state));
    }

    public static ProjectBase getStartProject(StartEntry startEntry) {
        if (startEntry == null) {
            return null;
        }
        Key key = startEntry.getStartFileProject();
        ProjectBase projectBase = (ProjectBase)RepositoryUtils.get(key);
        return projectBase;
    }

    public static boolean isCppFile(CsmFile csmFile) {
        return csmFile instanceof FileImpl && ((FileImpl)csmFile).isCppFile();
    }

    public static CsmFile.FileType getFileType(NativeFileItem nativeFileItem) {
        switch (nativeFileItem.getLanguage()) {
            case C: {
                return CsmFile.FileType.SOURCE_C_FILE;
            }
            case CPP: {
                return CsmFile.FileType.SOURCE_CPP_FILE;
            }
            case FORTRAN: {
                return CsmFile.FileType.SOURCE_FORTRAN_FILE;
            }
            case C_HEADER: {
                return CsmFile.FileType.HEADER_FILE;
            }
        }
        return CsmFile.FileType.UNDEFINED_FILE;
    }

    public static boolean acceptNativeItem(NativeFileItem nativeFileItem) {
        if (nativeFileItem.getFileObject() == null || !nativeFileItem.getFileObject().isValid()) {
            return false;
        }
        NativeFileItem.Language language = nativeFileItem.getLanguage();
        return (language == NativeFileItem.Language.C || language == NativeFileItem.Language.CPP || language == NativeFileItem.Language.FORTRAN || language == NativeFileItem.Language.C_HEADER) && !nativeFileItem.isExcluded();
    }

    static {
        if (LOG_LEVEL == -1) {
            if (TraceFlags.DEBUG) {
                LOG.setLevel(Level.ALL);
            } else {
                LOG.setLevel(Level.SEVERE);
            }
        }
    }
}

