/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.FileKey;
import org.netbeans.modules.cnd.modelimpl.repository.IncludeKey;
import org.netbeans.modules.cnd.modelimpl.repository.InheritanceKey;
import org.netbeans.modules.cnd.modelimpl.repository.InstantiationKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyManager;
import org.netbeans.modules.cnd.modelimpl.repository.MacroKey;
import org.netbeans.modules.cnd.modelimpl.repository.NamespaceKey;
import org.netbeans.modules.cnd.modelimpl.repository.OffsetableDeclarationKey;
import org.netbeans.modules.cnd.modelimpl.repository.OffsetableKey;
import org.netbeans.modules.cnd.modelimpl.repository.ParamListKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectFileNameBasedKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.spi.Key;

public class KeyUtilities {
    private KeyUtilities() {
    }

    public static Key createFileKey(FileImpl fileImpl) {
        return KeyManager.instance().getSharedKey(new FileKey(fileImpl));
    }

    public static Key createNamespaceKey(CsmNamespace csmNamespace) {
        return new NamespaceKey(csmNamespace);
    }

    public static Key createProjectKey(ProjectBase projectBase) {
        return KeyUtilities.createProjectKey(projectBase.getUniqueName());
    }

    public static Key createProjectKey(CharSequence charSequence) {
        return new ProjectKey(charSequence);
    }

    public static Key createProjectKey(NativeProject nativeProject) {
        return KeyUtilities.createProjectKey(ProjectBase.getUniqueName(nativeProject));
    }

    public static Key createOffsetableDeclarationKey(OffsetableDeclarationBase<?> offsetableDeclarationBase) {
        assert (offsetableDeclarationBase != null);
        return new OffsetableDeclarationKey(offsetableDeclarationBase);
    }

    public static Key createUnnamedOffsetableDeclarationKey(OffsetableDeclarationBase<?> offsetableDeclarationBase, int n) {
        assert (offsetableDeclarationBase != null);
        return new OffsetableDeclarationKey(offsetableDeclarationBase, n);
    }

    public static Key createMacroKey(CsmMacro csmMacro) {
        assert (csmMacro != null);
        return new MacroKey(csmMacro);
    }

    public static Key createIncludeKey(CsmInclude csmInclude) {
        assert (csmInclude != null);
        return KeyManager.instance().getSharedKey(new IncludeKey(csmInclude));
    }

    public static Key createInheritanceKey(CsmInheritance csmInheritance) {
        assert (csmInheritance != null);
        return KeyManager.instance().getSharedKey(new InheritanceKey(csmInheritance));
    }

    public static <T extends CsmNamedElement> Key createParamListKey(CsmParameterList<T> csmParameterList) {
        assert (csmParameterList != null);
        return new ParamListKey(csmParameterList);
    }

    public static Key createInstantiationKey(CsmInstantiation csmInstantiation) {
        assert (csmInstantiation != null);
        return new InstantiationKey(csmInstantiation);
    }

    public static int getUnitId(CharSequence charSequence) {
        return RepositoryUtils.getUnitId(charSequence);
    }

    public static CharSequence getUnitName(int n) {
        return RepositoryUtils.getUnitName(n);
    }

    public static int getFileIdByName(int n, CharSequence charSequence) {
        return RepositoryUtils.getFileIdByName(n, charSequence);
    }

    public static CharSequence getFileNameById(int n, int n2) {
        return RepositoryUtils.getFileNameById(n, n2);
    }

    public static CharSequence getFileNameByIdSafe(int n, int n2) {
        return RepositoryUtils.getFileNameByIdSafe(n, n2);
    }

    public static CsmDeclaration.Kind getKeyKind(Key key) {
        if (key instanceof OffsetableDeclarationKey) {
            return Utils.getCsmDeclarationKind(((OffsetableDeclarationKey)key).getKind());
        }
        return null;
    }

    public static CsmVisibility getKeyVisibility(Key key) {
        if (key instanceof InheritanceKey) {
            Utils.getCsmVisibility(((InheritanceKey)key).getKind());
        }
        return null;
    }

    public static char getKeyChar(Key key) {
        if (key instanceof OffsetableKey) {
            return ((OffsetableKey)key).getKind();
        }
        return '\u0000';
    }

    public static CharSequence getKeyName(Key key) {
        if (key instanceof OffsetableKey) {
            return ((OffsetableKey)key).getName();
        }
        if (key instanceof FileKey) {
            return ((FileKey)key).getName();
        }
        if (key instanceof ProjectKey) {
            return ((ProjectKey)key).getProjectName();
        }
        return null;
    }

    public static int getProjectFileIndex(Key key) {
        if (key instanceof ProjectFileNameBasedKey) {
            return ((ProjectFileNameBasedKey)key).getProjectFileIndex();
        }
        return -1;
    }

    public static int getProjectIndex(Key key) {
        if (key instanceof ProjectFileNameBasedKey) {
            return ((ProjectFileNameBasedKey)key).getUnitId();
        }
        if (key instanceof ProjectKey) {
            return ((ProjectKey)key).getUnitId();
        }
        return -1;
    }

    public static int getKeyStartOffset(Key key) {
        if (key instanceof OffsetableKey) {
            return ((OffsetableKey)key).getStartOffset();
        }
        return -1;
    }

    public static int getKeyEndOffset(Key key) {
        if (key instanceof OffsetableKey) {
            return ((OffsetableKey)key).getEndOffset();
        }
        return -1;
    }
}

