/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;

public class RepositoryListenerImpl
implements RepositoryListener {
    private static final RepositoryListenerImpl instance = new RepositoryListenerImpl();
    private static final int IMPLICIT_CLOSE_INTERVAL = Integer.getInteger("cnd.implicit.close.interval", 20);
    private static final String TRACE_PROJECT_NAME = System.getProperty("cnd.repository.trace.project");
    private static final boolean TRACE_PROJECT = TRACE_PROJECT_NAME != null && TRACE_PROJECT_NAME.length() > 0;
    private final Object lock = new Lock();
    private Map<CharSequence, UnitTimer> unitTimers = new HashMap<CharSequence, UnitTimer>();
    private Set<CharSequence> explicitelyOpened = new HashSet<CharSequence>();

    private RepositoryListenerImpl() {
        Runtime.getRuntime().addShutdownHook(new RepositoryShutdownHook());
    }

    public static RepositoryListenerImpl instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unitOpened(CharSequence charSequence) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: unitOpened %s\n", charSequence);
        }
        if (TRACE_PROJECT && TRACE_PROJECT_NAME.equals(charSequence)) {
            this.trace("Watched project %s is opening\n", charSequence);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.explicitelyOpened.contains(charSequence)) {
                if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                    this.trace("RepositoryListener: implicit open !!! %s\n", charSequence);
                }
                this.unitTimers.put(charSequence, new UnitTimer(charSequence, IMPLICIT_CLOSE_INTERVAL * 1000));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unitClosed(CharSequence charSequence) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: unitClosed %s\n", charSequence);
        }
        if (TRACE_PROJECT && TRACE_PROJECT_NAME.equals(charSequence)) {
            this.trace("Watched project %s is explicitly closing\n", charSequence);
        }
        Object object = this.lock;
        synchronized (object) {
            this.killTimer(charSequence);
            this.explicitelyOpened.remove(charSequence);
        }
    }

    public void anExceptionHappened(CharSequence charSequence, RepositoryException repositoryException) {
        assert (repositoryException != null);
        if (repositoryException.getCause() != null) {
            repositoryException.getCause().printStackTrace(System.err);
        }
        DiagnosticExceptoins.register(repositoryException.getCause());
    }

    private void killTimer(CharSequence charSequence) {
        UnitTimer unitTimer = this.unitTimers.remove(charSequence);
        if (unitTimer != null) {
            if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                this.trace("RepositoryListener: killing timer for %s\n", charSequence);
            }
            unitTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExplicitOpen(CharSequence charSequence) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: onExplicitOpen %s\n", charSequence);
        }
        Object object = this.lock;
        synchronized (object) {
            this.killTimer(charSequence);
            this.explicitelyOpened.add(charSequence);
        }
    }

    public void onExplicitClose(CharSequence charSequence) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: onExplicitClose %s\n", charSequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutElapsed(CharSequence charSequence) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: timeout elapsed for %s\n", charSequence);
        }
        Object object = this.lock;
        synchronized (object) {
            UnitTimer unitTimer = this.unitTimers.remove(charSequence);
            if (unitTimer != null) {
                if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                    this.trace("RepositoryListener: scheduling closure for %s\n", charSequence);
                }
                unitTimer.cancel();
                this.scheduleClosing(charSequence, Collections.<CharSequence>emptySet());
            }
        }
    }

    private void scheduleClosing(final CharSequence charSequence, Set<CharSequence> set) {
        if (this.explicitelyOpened.contains(charSequence)) {
            if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                this.trace("Cancelling closure (A) for implicitely opened unit %s\n", charSequence);
            }
            return;
        }
        ModelImpl.instance().enqueueModelTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = RepositoryListenerImpl.this.lock;
                synchronized (object) {
                    if (RepositoryListenerImpl.this.explicitelyOpened.contains(charSequence)) {
                        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                            RepositoryListenerImpl.this.trace("Cancelling closure (B) for implicitely opened unit %s\n", new Object[]{charSequence});
                        }
                        return;
                    }
                }
                if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                    RepositoryListenerImpl.this.trace("RepositoryListener: closing implicitely opened unit %s\n", new Object[]{charSequence});
                }
                if (TRACE_PROJECT && TRACE_PROJECT_NAME.equals(charSequence)) {
                    RepositoryListenerImpl.this.trace("Watched project %s is implicitely closing\n", new Object[]{charSequence});
                }
                RepositoryUtils.closeUnit(charSequence, null, !TraceFlags.PERSISTENT_REPOSITORY);
            }
        }, "Closing implicitly opened project");
    }

    private void trace(String string, Object ... objectArray) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = System.currentTimeMillis();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i + 1] = objectArray[i];
        }
        System.err.printf("RepositoryListener [%d] " + string, objectArray2);
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private class UnitTimer
    implements ActionListener {
        private final CharSequence unitName;
        private final Timer timer;

        public UnitTimer(CharSequence charSequence, int n) {
            this.unitName = charSequence;
            this.timer = new Timer(n, this);
            this.timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RepositoryListenerImpl.this.timeoutElapsed(this.unitName);
        }

        public void cancel() {
            this.timer.stop();
        }
    }

    private static class RepositoryShutdownHook
    extends Thread {
        public RepositoryShutdownHook() {
            this.setName("Repository Shutdown Hook Thread");
        }

        @Override
        public void run() {
            RepositoryUtils.shutdown();
        }
    }
}

