/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.midp.components.ProjectResourceResolver;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class MidpProjectSupport {
    private static final Lookup.Result<ProjectResourceResolver> resolvers = Lookup.getDefault().lookupResult(ProjectResourceResolver.class);

    private MidpProjectSupport() {
    }

    public static Collection<? extends ProjectResourceResolver> getAllResolvers() {
        return resolvers.allInstances();
    }

    public static void addLibraryToProject(final DesignDocument document, final String ... libraryNames) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Project project = MidpProjectSupport.getProjectForDocument(document);
                if (project == null) {
                    return;
                }
                ProjectClassPathExtender extender = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
                LibraryManager libraryManager = LibraryManager.getDefault();
                for (String libraryName : libraryNames) {
                    Library library = libraryManager.getLibrary(libraryName);
                    if (library == null) continue;
                    try {
                        extender.addLibrary(library);
                    }
                    catch (IOException e) {
                        Debug.warning((Object[])new Object[]{e});
                    }
                }
            }
        });
    }

    public static void addArchiveFileToProject(final DesignDocument document, final FileObject ... archiveFiles) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Project project = MidpProjectSupport.getProjectForDocument(document);
                if (project == null) {
                    return;
                }
                ProjectClassPathExtender extender = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
                for (FileObject file : archiveFiles) {
                    if (file == null || !file.isValid()) continue;
                    try {
                        extender.addArchiveFile(file);
                    }
                    catch (IOException e) {
                        Debug.warning((Object[])new Object[]{e});
                    }
                }
            }
        });
    }

    public static Project getProjectForDocument(DesignDocument document) {
        if (document == null) {
            return null;
        }
        DataObjectContext context = org.netbeans.modules.vmd.api.io.ProjectUtils.getDataObjectContextForDocument((DesignDocument)document);
        if (context == null) {
            return null;
        }
        return org.netbeans.modules.vmd.api.io.ProjectUtils.getProject((DataObjectContext)context);
    }

    public static Map<FileObject, FileObject> getFileObjectsForRelativeResourcePath(DesignDocument document, String relativeResourcePath) {
        assert (document != null);
        assert (relativeResourcePath != null);
        if (relativeResourcePath.startsWith("/")) {
            relativeResourcePath = relativeResourcePath.substring(1);
        }
        HashMap<FileObject, FileObject> matches = new HashMap<FileObject, FileObject>();
        DataObjectContext context = org.netbeans.modules.vmd.api.io.ProjectUtils.getDataObjectContextForDocument((DesignDocument)document);
        if (context == null) {
            return Collections.emptyMap();
        }
        DataObject dataObject = context.getDataObject();
        assert (dataObject != null);
        FileObject primaryFile = dataObject.getPrimaryFile();
        assert (primaryFile != null);
        Project project = MidpProjectSupport.getProjectForDocument(document);
        if (project == null || primaryFile == null || !primaryFile.isValid()) {
            return new HashMap<FileObject, FileObject>(0);
        }
        List<ClassPath> classPathList = MidpProjectSupport.getClassPath(project, primaryFile);
        assert (classPathList != null);
        for (ClassPath cp : classPathList) {
            FileObject[] roots;
            for (FileObject root : roots = cp.getRoots()) {
                Enumeration children = root.getChildren(true);
                while (children.hasMoreElements()) {
                    FileObject child = (FileObject)children.nextElement();
                    String curRelPath = FileUtil.getRelativePath((FileObject)root, (FileObject)child);
                    if (!relativeResourcePath.equals(curRelPath)) continue;
                    matches.put(child, root);
                }
            }
        }
        for (ProjectResourceResolver resolver : resolvers.allInstances()) {
            Collection<FileObject> collection = resolver.getResourceRoots(project, document.getDocumentInterface().getProjectType());
            if (collection == null) continue;
            for (FileObject root : collection) {
                Enumeration enumeration = root.getChildren(true);
                while (enumeration.hasMoreElements()) {
                    FileObject object = (FileObject)enumeration.nextElement();
                    String curRelPath = FileUtil.getRelativePath((FileObject)root, (FileObject)object);
                    if (!relativeResourcePath.equals(curRelPath)) continue;
                    matches.put(object, root);
                }
            }
        }
        return matches;
    }

    public static Map<FileObject, String> getImagesForProject(DesignDocument document, boolean pngOnly) {
        String EXTENSION_JPEG = "jpeg";
        String EXTENSION_JPG = "jpg";
        String EXTENSION_GIF = "gif";
        String EXTENSION_PNG = "png";
        assert (document != null);
        Map<FileObject, String> imageFileObjects = null;
        imageFileObjects = pngOnly ? MidpProjectSupport.getAllFilesForProjectByExt(document, Arrays.asList(EXTENSION_PNG)) : MidpProjectSupport.getAllFilesForProjectByExt(document, Arrays.asList(EXTENSION_JPEG, EXTENSION_JPG, EXTENSION_GIF, EXTENSION_PNG));
        return imageFileObjects;
    }

    public static Map<FileObject, String> getAllFilesForProjectByExt(DesignDocument document, Collection<String> fileExtensions) {
        assert (fileExtensions != null);
        assert (document != null);
        WeakHashMap<FileObject, String> matches = new WeakHashMap<FileObject, String>();
        DataObjectContext context = org.netbeans.modules.vmd.api.io.ProjectUtils.getDataObjectContextForDocument((DesignDocument)document);
        if (context == null) {
            return Collections.EMPTY_MAP;
        }
        DataObject dataObject = context.getDataObject();
        if (dataObject == null) {
            return Collections.EMPTY_MAP;
        }
        FileObject primaryFile = dataObject.getPrimaryFile();
        if (primaryFile == null) {
            return Collections.EMPTY_MAP;
        }
        Project project = MidpProjectSupport.getProjectForDocument(document);
        List<ClassPath> classPathList = MidpProjectSupport.getClassPath(project, primaryFile);
        if (classPathList == null) {
            return Collections.EMPTY_MAP;
        }
        for (ClassPath cp : classPathList) {
            FileObject[] roots;
            for (FileObject root : roots = cp.getRoots()) {
                MidpProjectSupport.extractFiles(root, root, matches, fileExtensions);
            }
        }
        for (ProjectResourceResolver resolver : resolvers.allInstances()) {
            Collection<FileObject> collection = resolver.getResourceRoots(project, document.getDocumentInterface().getProjectType());
            if (collection == null) continue;
            for (FileObject root : collection) {
                MidpProjectSupport.extractFiles(root, root, matches, fileExtensions);
            }
        }
        return matches;
    }

    private static void extractFiles(FileObject root, FileObject current, Map<FileObject, String> bank, Collection<String> imgFileExtensions) {
        if (current.isFolder()) {
            FileObject[] children;
            for (FileObject fo : children = current.getChildren()) {
                MidpProjectSupport.extractFiles(root, fo, bank, imgFileExtensions);
            }
        } else {
            String currentExt = current.getExt();
            for (String ext : imgFileExtensions) {
                if (!ext.equalsIgnoreCase(currentExt)) continue;
                String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)current);
                bank.put(current, "/" + relativePath);
            }
        }
    }

    private static List<ClassPath> getClassPath(Project project, FileObject fileObject) {
        ArrayList<ClassPath> classPathList = new ArrayList<ClassPath>();
        ClassPathProvider cpp = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        classPathList.add(cpp.findClassPath(fileObject, "classpath/compile"));
        classPathList.add(cpp.findClassPath(fileObject, "classpath/source"));
        return classPathList;
    }

    public static ClasspathInfo getClasspathInfo(Project project) {
        SourceGroup group = MidpProjectSupport.getSourceGroup(project);
        if (group == null) {
            return null;
        }
        FileObject fileObject = group.getRootFolder();
        return ClasspathInfo.create((FileObject)fileObject);
    }

    public static SourceGroup getSourceGroup(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroups == null || sourceGroups.length < 1) {
            return null;
        }
        return sourceGroups[0];
    }
}

