/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.vmd.api.codegen.CodeClassLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.general.ClassCD;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public final class RootCode {
    private RootCode() {
    }

    public static Presenter createInitializePresenter() {
        return new CodeInitializeMethodPresenter();
    }

    public static void collectRequiredComponents(DesignComponent component, Collection<DesignComponent> requiredComponents) {
        for (CodeComponentDependencyPresenter presenter : component.getPresenters(CodeComponentDependencyPresenter.class)) {
            presenter.collectRequiredComponents(requiredComponents);
        }
    }

    public static List<DesignComponent> performTopologicalSort(DesignDocument document) {
        ArrayList<DesignComponent> list = new ArrayList<DesignComponent>();
        HashMap<DesignComponent, HashSet<DesignComponent>> map = new HashMap<DesignComponent, HashSet<DesignComponent>>();
        for (DesignComponent component : DocumentSupport.gatherAllComponents((DesignDocument)document)) {
            if (document.getDescriptorRegistry().isInHierarchy(ClassCD.TYPEID, component.getType()) && !MidpTypes.getBoolean(component.readProperty("lazyInit"))) {
                list.add(component);
            }
            ArrayList<DesignComponent> requiredComponents = new ArrayList<DesignComponent>();
            RootCode.collectRequiredComponents(component, requiredComponents);
            for (DesignComponent requiredComponent : requiredComponents) {
                HashSet<DesignComponent> edges = (HashSet<DesignComponent>)map.get(requiredComponent);
                if (edges == null) {
                    edges = new HashSet<DesignComponent>();
                    map.put(requiredComponent, edges);
                }
                edges.add(component);
            }
        }
        try {
            return Utilities.topologicalSort(list, map);
        }
        catch (TopologicalSortException e) {
            Debug.warning((Object[])new Object[]{"Topological sort failed", "UnsortableSets", e.unsortableSets()});
            return e.partialSort();
        }
    }

    private static class CodeInitializeMethodPresenter
    extends CodeClassLevelPresenter.Adapter {
        private CodeInitializeMethodPresenter() {
        }

        protected void generateClassBodyCode(StyledDocument document) {
            MultiGuardedSection section = MultiGuardedSection.create((StyledDocument)document, (String)(this.getComponent().getComponentID() + "-initialize"));
            section.getWriter().write("//<editor-fold defaultstate=\"collapsed\" desc=\" Generated Method: initialize \">\n");
            section.getWriter().write("/**\n * Initializes the application.\n * It is called only once when the MIDlet is started. The method is called before the <code>startMIDlet</code> method.\n */\n");
            section.getWriter().write("private void initialize () {\n").commit();
            section.switchToEditable(this.getComponent().getComponentID() + "-preInitialize");
            section.getWriter().write(" // write pre-initialize user code here\n").commit();
            section.switchToGuarded();
            List<DesignComponent> components = RootCode.performTopologicalSort(this.getComponent().getDocument());
            for (DesignComponent component : components) {
                for (CodeClassLevelPresenter presenter : component.getPresenters(CodeClassLevelPresenter.class)) {
                    presenter.generateInitializeSectionCode(section);
                }
            }
            section.getWriter().commit();
            section.switchToEditable(this.getComponent().getComponentID() + "-postInitialize");
            section.getWriter().write(" // write post-initialize user code here\n").commit();
            section.switchToGuarded();
            section.getWriter().write("}\n");
            section.getWriter().write("//</editor-fold>\n").commit();
            section.close();
        }
    }

    public static abstract class CodeComponentDependencyPresenter
    extends Presenter {
        protected abstract void collectRequiredComponents(Collection<DesignComponent> var1);
    }
}

