/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.listeners;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.vmd.api.codegen.CodeClassLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeGlobalLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeMultiGuardedLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeReferencePresenter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.components.sources.CommandEventSourceCD;
import org.netbeans.modules.vmd.midp.components.sources.ItemCommandEventSourceCD;

class EventListenerCode {
    EventListenerCode() {
    }

    private static ExpressionTree findImplementIdentifier(Trees trees, TreePath classTreePath, String fullyQualifiedName) {
        ClassTree clazz = (ClassTree)classTreePath.getLeaf();
        for (Tree tree : clazz.getImplementsClause()) {
            Element element = trees.getElement(new TreePath(classTreePath, tree));
            if (!EventListenerCode.equalsElementWithFQN(element, fullyQualifiedName)) continue;
            return (ExpressionTree)tree;
        }
        return null;
    }

    private static boolean equalsElementWithFQN(Element element, String fullyQualifiedName) {
        TypeElement type;
        return (element.getKind().isInterface() || element.getKind().isClass()) && (type = (TypeElement)element).getQualifiedName().contentEquals(fullyQualifiedName);
    }

    public static class CodeItemCommandListenerPresenter
    extends CodeClassLevelPresenter.Adapter {
        protected void generateClassBodyCode(StyledDocument document) {
            List sources = DocumentSupport.gatherAllComponentsOfTypeID((DesignDocument)this.getComponent().getDocument(), (TypeID)ItemCommandEventSourceCD.TYPEID);
            if (sources.size() == 0) {
                return;
            }
            MultiGuardedSection section = MultiGuardedSection.create((StyledDocument)document, (String)(this.getComponent().getComponentID() + "-itemCommandAction"));
            section.getWriter().write("//<editor-fold defaultstate=\"collapsed\" desc=\" Generated Method: commandAction for Items \">\n");
            section.getWriter().write("/**\n * Called by a system to indicated that a command has been invoked on a particular item.\n * @param command the Command that was invoked\n * @param displayable the Item where the command was invoked\n */\n");
            section.getWriter().write("public void commandAction (Command command, Item item) {\n").commit();
            section.switchToEditable(this.getComponent().getComponentID() + "-preItemCommandAction");
            section.getWriter().write(" // write pre-action user code here\n").commit();
            section.switchToGuarded();
            this.resolveFirstLevel(section, sources);
            section.switchToEditable(this.getComponent().getComponentID() + "-postItemCommandAction");
            section.getWriter().write(" // write post-action user code here\n").commit();
            section.switchToGuarded();
            section.getWriter().write("}\n");
            section.getWriter().write("//</editor-fold>\n").commit();
            section.close();
        }

        private void resolveFirstLevel(MultiGuardedSection section, List<DesignComponent> sources) {
            HashMap<String, ArrayList<DesignComponent>> items2sources = this.gatherItems(sources);
            ArrayList<String> items = new ArrayList<String>(items2sources.keySet());
            Collections.sort(items);
            for (int i = 0; i < items.size(); ++i) {
                String item = items.get(i);
                if (i > 0) {
                    section.getWriter().write("else ");
                }
                section.getWriter().write("if (item == " + item + ") {\n");
                this.resolveSecondLevel(section, (List<DesignComponent>)items2sources.get(item));
                assert (section.isGuarded());
                if (i < items.size() - 1) {
                    section.getWriter().write("} ");
                    continue;
                }
                section.getWriter().write("}\n");
            }
            section.getWriter().commit();
        }

        private void resolveSecondLevel(MultiGuardedSection section, List<DesignComponent> sources) {
            HashMap<String, ArrayList<DesignComponent>> commands2sources = this.gatherCommands(sources);
            ArrayList<String> commands = new ArrayList<String>(commands2sources.keySet());
            Collections.sort(commands);
            for (int i = 0; i < commands.size(); ++i) {
                String command = commands.get(i);
                if (i > 0) {
                    section.getWriter().write("else ");
                }
                section.getWriter().write("if (command == " + command + ") {\n");
                for (DesignComponent source : commands2sources.get(command)) {
                    CodeMultiGuardedLevelPresenter.generateMultiGuardedSectionCode((MultiGuardedSection)section, (DesignComponent)source);
                }
                assert (section.isGuarded());
                if (i < commands.size() - 1) {
                    section.getWriter().write("} ");
                    continue;
                }
                section.getWriter().write("}\n");
            }
        }

        private HashMap<String, ArrayList<DesignComponent>> gatherItems(List<DesignComponent> sources) {
            HashMap<String, ArrayList<DesignComponent>> i2s = new HashMap<String, ArrayList<DesignComponent>>();
            for (DesignComponent source : sources) {
                String item = CodeReferencePresenter.generateDirectAccessCode((DesignComponent)ItemCommandEventSourceCD.getItemComponent(source));
                ArrayList<Object> s = i2s.get(item);
                if (s == null) {
                    s = new ArrayList();
                    i2s.put(item, s);
                }
                s.add(source);
            }
            return i2s;
        }

        private HashMap<String, ArrayList<DesignComponent>> gatherCommands(List<DesignComponent> sources) {
            HashMap<String, ArrayList<DesignComponent>> c2s = new HashMap<String, ArrayList<DesignComponent>>();
            for (DesignComponent source : sources) {
                String command = CodeReferencePresenter.generateDirectAccessCode((DesignComponent)source.readProperty("command").getComponent());
                ArrayList<Object> s = c2s.get(command);
                if (s == null) {
                    s = new ArrayList();
                    c2s.put(command, s);
                }
                s.add(source);
            }
            return c2s;
        }
    }

    public static class CodeCommandListenerPresenter
    extends CodeClassLevelPresenter.Adapter {
        protected void generateClassBodyCode(StyledDocument document) {
            List sources = DocumentSupport.gatherAllComponentsOfTypeID((DesignDocument)this.getComponent().getDocument(), (TypeID)CommandEventSourceCD.TYPEID);
            if (sources.size() == 0) {
                return;
            }
            MultiGuardedSection section = MultiGuardedSection.create((StyledDocument)document, (String)(this.getComponent().getComponentID() + "-commandAction"));
            section.getWriter().write("//<editor-fold defaultstate=\"collapsed\" desc=\" Generated Method: commandAction for Displayables \">\n");
            section.getWriter().write("/**\n * Called by a system to indicated that a command has been invoked on a particular displayable.\n * @param command the Command that was invoked\n * @param displayable the Displayable where the command was invoked\n */\n");
            section.getWriter().write("public void commandAction (Command command, Displayable displayable) {\n").commit();
            section.switchToEditable(this.getComponent().getComponentID() + "-preCommandAction");
            section.getWriter().write(" // write pre-action user code here\n").commit();
            section.switchToGuarded();
            this.resolveFirstLevel(section, sources);
            section.switchToEditable(this.getComponent().getComponentID() + "-postCommandAction");
            section.getWriter().write(" // write post-action user code here\n").commit();
            section.switchToGuarded();
            section.getWriter().write("}\n");
            section.getWriter().write("//</editor-fold>\n").commit();
            section.close();
        }

        private void resolveFirstLevel(MultiGuardedSection section, List<DesignComponent> sources) {
            HashMap<String, ArrayList<DesignComponent>> displayables2sources = this.gatherDisplayables(sources);
            ArrayList<String> displayables = new ArrayList<String>(displayables2sources.keySet());
            Collections.sort(displayables);
            for (int i = 0; i < displayables.size(); ++i) {
                String displayable = displayables.get(i);
                if (i > 0) {
                    section.getWriter().write("else ");
                }
                section.getWriter().write("if (displayable == " + displayable + ") {\n");
                this.resolveSecondLevel(section, (List<DesignComponent>)displayables2sources.get(displayable));
                assert (section.isGuarded());
                if (i < displayables.size() - 1) {
                    section.getWriter().write("} ");
                    continue;
                }
                section.getWriter().write("}\n");
            }
            section.getWriter().commit();
        }

        private void resolveSecondLevel(MultiGuardedSection section, List<DesignComponent> sources) {
            HashMap<String, ArrayList<DesignComponent>> commands2sources = this.gatherCommands(sources);
            ArrayList<String> commands = new ArrayList<String>(commands2sources.keySet());
            Collections.sort(commands);
            for (int i = 0; i < commands.size(); ++i) {
                String command = commands.get(i);
                if (i > 0) {
                    section.getWriter().write("else ");
                }
                section.getWriter().write("if (command == " + command + ") {\n");
                for (DesignComponent source : commands2sources.get(command)) {
                    CodeMultiGuardedLevelPresenter.generateMultiGuardedSectionCode((MultiGuardedSection)section, (DesignComponent)source);
                }
                assert (section.isGuarded());
                if (i < commands.size() - 1) {
                    section.getWriter().write("} ");
                    continue;
                }
                section.getWriter().write("}\n");
            }
        }

        private HashMap<String, ArrayList<DesignComponent>> gatherDisplayables(List<DesignComponent> sources) {
            HashMap<String, ArrayList<DesignComponent>> d2s = new HashMap<String, ArrayList<DesignComponent>>();
            for (DesignComponent source : sources) {
                String displayable = CodeReferencePresenter.generateDirectAccessCode((DesignComponent)source.readProperty("displayable").getComponent());
                ArrayList<Object> s = d2s.get(displayable);
                if (s == null) {
                    s = new ArrayList();
                    d2s.put(displayable, s);
                }
                s.add(source);
            }
            return d2s;
        }

        private HashMap<String, ArrayList<DesignComponent>> gatherCommands(List<DesignComponent> sources) {
            HashMap<String, ArrayList<DesignComponent>> c2s = new HashMap<String, ArrayList<DesignComponent>>();
            for (DesignComponent source : sources) {
                String command = CodeReferencePresenter.generateDirectAccessCode((DesignComponent)source.readProperty("command").getComponent());
                ArrayList<Object> s = c2s.get(command);
                if (s == null) {
                    s = new ArrayList();
                    c2s.put(command, s);
                }
                s.add(source);
            }
            return c2s;
        }
    }

    private static class ContainsMethodTreeVisitor
    extends TreePathScanner<Void, Void> {
        private Trees trees;
        private String methodName;
        private String[] parameters;
        private boolean isFirstLevel;
        private TreePath classTreePath;
        private boolean methodExists;

        public ContainsMethodTreeVisitor(Trees trees, String methodName, String ... parameters) {
            this.trees = trees;
            this.methodName = methodName;
            this.parameters = parameters;
            this.methodExists = false;
            this.isFirstLevel = false;
        }

        public boolean isMethodExists() {
            return this.methodExists;
        }

        public TreePath getClassTreePath() {
            return this.classTreePath;
        }

        @Override
        public Void visitClass(ClassTree node, Void p) {
            if (!this.isFirstLevel) {
                this.isFirstLevel = true;
                if (node.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) {
                    this.classTreePath = this.getCurrentPath();
                    return (Void)super.visitClass(node, p);
                }
                this.isFirstLevel = false;
            }
            return null;
        }

        @Override
        public Void visitMethod(MethodTree node, Void p) {
            List<? extends VariableTree> parameters;
            if (node.getName().contentEquals(this.methodName) && this.parameters.length == (parameters = node.getParameters()).size()) {
                boolean corrent = true;
                for (int i = 0; i < this.parameters.length; ++i) {
                    Tree type = parameters.get(i).getType();
                    TreePath treePath = new TreePath(this.getCurrentPath(), type);
                    Element element = this.trees.getElement(treePath);
                    if (EventListenerCode.equalsElementWithFQN(element, this.parameters[i])) continue;
                    corrent = false;
                    break;
                }
                if (corrent) {
                    this.methodExists = true;
                }
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableTree node, Void p) {
            return null;
        }
    }

    static class CodeImplementsPresenter
    extends CodeGlobalLevelPresenter {
        private String className;
        private String methodName;
        private String[] parameters;

        public CodeImplementsPresenter(String className, String methodName, String ... parameters) {
            this.className = className;
            this.methodName = methodName;
            this.parameters = parameters;
        }

        protected void performGlobalGeneration(StyledDocument styledDocument) {
            JavaSource source = JavaSource.forDocument((Document)styledDocument);
            try {
                ModificationResult result = source.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws Exception {
                        workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        CompilationUnitTree compilationUnit = workingCopy.getCompilationUnit();
                        TreeMaker treeMaker = workingCopy.getTreeMaker();
                        Trees trees = workingCopy.getTrees();
                        ContainsMethodTreeVisitor visitor = new ContainsMethodTreeVisitor(trees, CodeImplementsPresenter.this.methodName, CodeImplementsPresenter.this.parameters);
                        visitor.scan(compilationUnit, null);
                        TreePath classTreePath = visitor.getClassTreePath();
                        if (classTreePath != null) {
                            ExpressionTree expressionTree = EventListenerCode.findImplementIdentifier(trees, classTreePath, CodeImplementsPresenter.this.className);
                            if (visitor.isMethodExists()) {
                                if (expressionTree == null) {
                                    TypeElement typeElement = workingCopy.getElements().getTypeElement(CodeImplementsPresenter.this.className);
                                    ExpressionTree implementsClause = typeElement != null ? treeMaker.QualIdent((Element)typeElement) : treeMaker.Identifier((CharSequence)CodeImplementsPresenter.this.className);
                                    ClassTree oldClassTree = (ClassTree)classTreePath.getLeaf();
                                    ClassTree newClassTree = treeMaker.addClassImplementsClause(oldClassTree, (Tree)implementsClause);
                                    workingCopy.rewrite((Tree)oldClassTree, (Tree)newClassTree);
                                }
                            } else if (expressionTree != null) {
                                ClassTree oldClassTree = (ClassTree)classTreePath.getLeaf();
                                ClassTree newClassTree = treeMaker.removeClassImplementsClause(oldClassTree, (Tree)expressionTree);
                                workingCopy.rewrite((Tree)oldClassTree, (Tree)newClassTree);
                            }
                        }
                    }
                });
                result.commit();
            }
            catch (IOException e) {
                throw Debug.error((Object[])new Object[]{e});
            }
        }
    }
}

