/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.sources;

import java.awt.Image;
import java.util.List;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;
import org.netbeans.modules.vmd.midp.actions.MidpActionsSupport;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.actions.PropertiesAction;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class EventSourceSupport {
    private static final InfoPresenter.Resolver COMMAND_EVENT_SOURCE_RESOLVER = new EventSourceResolver("command", true);
    private static final InfoPresenter.Resolver ITEM_COMMAND_EVENT_SOURCE_RESOLVER = new EventSourceResolver("command", true);
    private static final String PROP_COMMAND = "command";

    static InfoPresenter.Resolver createCommandEventSourceInfoResolver() {
        return COMMAND_EVENT_SOURCE_RESOLVER;
    }

    static InfoPresenter.Resolver createItemCommandEventSourceInfoResolver() {
        return ITEM_COMMAND_EVENT_SOURCE_RESOLVER;
    }

    static void addActionsPresentres(List<Presenter> presenters) {
        EventSourceSupport.addActionsPresentres(presenters, true);
    }

    static void addActionsPresentres(List<Presenter> presenters, boolean allowRename) {
        for (Presenter presenter : presenters.toArray(new Presenter[presenters.size()])) {
            if (presenter instanceof ActionsPresenter) {
                presenters.remove(presenter);
            }
            if (!(presenter instanceof ActionsPresenter)) continue;
            presenters.remove(presenter);
        }
        MidpActionsSupport.addCommonActionsPresenters(presenters, true, true, allowRename, true, false);
        MidpActionsSupport.addMoveActionPresenter(presenters, "commands");
        presenters.addAll(ActionsSupport.createByReference((String)PROP_COMMAND, (Class[])new Class[]{PropertiesAction.class}));
    }

    private static class EventSourceResolver
    implements InfoPresenter.Resolver {
        private String propertyName;
        private boolean editable;

        private EventSourceResolver(String propertyName, boolean editable) {
            this.propertyName = propertyName;
            this.editable = editable;
        }

        public DesignEventFilter getEventFilter(DesignComponent component) {
            return new DesignEventFilter(new DesignEventFilter[0]).addDescentFilter(component, this.propertyName);
        }

        public String getDisplayName(DesignComponent component, InfoPresenter.NameType nameType) {
            switch (nameType) {
                case PRIMARY: {
                    return this.resolveName(component);
                }
                case SECONDARY: {
                    return NbBundle.getMessage(EventSourceSupport.class, (String)"TYPE_Command");
                }
                case TERTIARY: {
                    StringBuffer nameWithParent = new StringBuffer();
                    nameWithParent.append("<HTML>");
                    nameWithParent.append(this.resolveName(component));
                    nameWithParent.append(" <font color=\"#808080\">[");
                    nameWithParent.append(((InfoPresenter)component.getParentComponent().getPresenter(InfoPresenter.class)).getEditableName());
                    nameWithParent.append("]");
                    return nameWithParent.toString();
                }
            }
            throw Debug.illegalState((Object[])new Object[0]);
        }

        private String resolveName(DesignComponent component) {
            if ((component = component.readProperty(this.propertyName).getComponent()) == null) {
                return null;
            }
            PropertyValue value = component.readProperty("instanceName");
            if (value.getKind() == PropertyValue.Kind.VALUE && MidpTypes.TYPEID_JAVA_LANG_STRING.equals((Object)value.getType())) {
                return (String)value.getPrimitiveValue();
            }
            throw Debug.error((Object[])new Object[]{"Invalid instance name", value, "for component", component});
        }

        public boolean isEditable(DesignComponent component) {
            return this.editable;
        }

        public String getEditableName(DesignComponent component) {
            DesignComponent refComponent = component.readProperty(EventSourceSupport.PROP_COMMAND).getComponent();
            if (refComponent == null || refComponent.readProperty("instanceName") == null) {
                Debug.warning((Object[])new Object[]{"EventSource referenced " + component.toString() + " is null "});
                return null;
            }
            String name = (String)refComponent.readProperty("instanceName").getPrimitiveValue();
            return name;
        }

        public void setEditableName(DesignComponent component, String enteredName) {
            DesignComponent refComponent = component.readProperty(EventSourceSupport.PROP_COMMAND).getComponent();
            PropertyValue newName = InstanceNameResolver.createFromSuggested(refComponent, enteredName);
            refComponent.writeProperty("instanceName", newName);
        }

        public Image getIcon(DesignComponent component, InfoPresenter.IconType iconType) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/midp/resources/components/command_16.png");
        }
    }
}

