/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.palette;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.palette.PaletteProvider;
import org.netbeans.modules.vmd.midp.palette.wizard.AddToPaletteWizardAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.actions.SystemAction;

public class MidpPaletteProvider
implements PaletteProvider {
    public static final String CATEGORY_COMMANDS = "commands";
    public static final String CATEGORY_DISPLAYABLES = "displayables";
    public static final String CATEGORY_ELEMENTS = "elements";
    public static final String CATEGORY_ITEMS = "items";
    public static final String CATEGORY_PROCESS_FLOW = "flow";
    public static final String CATEGORY_RESOURCES = "resources";
    public static final String CATEGORY_CUSTOM = "custom";
    public static final String CATEGORY_DATABINDING = "databinding";
    private String[] paletteCategories = new String[]{"displayables", "commands", "elements", "items", "flow", "resources", "custom", "databinding"};
    private int[] categoryPositions = new int[]{100, 200, 300, 400, 500, 600, 1000, 710};

    public void initPaletteCategories(String projectType) {
        if (!"vmd-midp".equals(projectType)) {
            return;
        }
        try {
            FileObject paletteFolder = FileUtil.getConfigFile((String)(projectType + "/palette"));
            if (paletteFolder == null) {
                FileObject root = FileUtil.getConfigRoot();
                assert (root != null);
                FileObject projectFolder = root.getFileObject(projectType);
                if (projectFolder == null) {
                    projectFolder = root.createFolder(projectType);
                }
                paletteFolder = projectFolder.createFolder("palette");
            }
            paletteFolder.refresh(true);
            for (int i = 0; i < this.paletteCategories.length; ++i) {
                String categoryName = this.paletteCategories[i];
                FileObject catFO = paletteFolder.getFileObject(categoryName);
                if (catFO == null) {
                    catFO = paletteFolder.createFolder(categoryName);
                }
                catFO.setAttribute("SystemFileSystem.localizingBundle", (Object)"org.netbeans.modules.vmd.midp.palette.Bundle");
                catFO.setAttribute("SystemFileSystem.icon", (Object)new URL("nbresloc:/org/netbeans/modules/vmd/midp/resources/components/category_" + categoryName + "_16.png"));
                catFO.setAttribute("isExpanded", (Object)"true");
                catFO.setAttribute("position", (Object)this.categoryPositions[i]);
            }
        }
        catch (IOException e) {
            Debug.warning((Object[])new Object[]{"Can't set attributes for palette category folder", e});
        }
    }

    public List<? extends Action> getActions(String projectType) {
        if (!"vmd-midp".equals(projectType)) {
            return null;
        }
        return Collections.singletonList(SystemAction.get(AddToPaletteWizardAction.class));
    }
}

