/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.palette.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.ComponentSerializationSupport;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.PresenterSerializer;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.general.ClassCD;
import org.netbeans.modules.vmd.midp.serialization.MidpAddImportPresenterSerializer;
import org.netbeans.modules.vmd.midp.serialization.MidpPropertyPresenterSerializer;
import org.netbeans.modules.vmd.midp.serialization.MidpSetterPresenterSerializer;
import org.netbeans.modules.vmd.midp.serialization.MidpTypesConvertor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class ComponentInstaller {
    public static void install(final Map<String, Item> allFoundComponents, final List<Item> componentsToInstall) {
        ComponentSerializationSupport.runUnderDescriptorRegistryWriteAccess((String)"vmd-midp", (Runnable)new Runnable(){

            @Override
            public void run() {
                ComponentInstaller.installCore(allFoundComponents, componentsToInstall);
            }
        });
        ComponentSerializationSupport.refreshDescriptorRegistry((String)"vmd-midp");
    }

    private static void installCore(Map<String, Item> allFoundComponents, List<Item> componentsToInstall) {
        HashMap<String, Item> toInstall = new HashMap<String, Item>();
        for (Item item : componentsToInstall) {
            ComponentInstaller.recursiveAdd(toInstall, allFoundComponents, item);
        }
        for (Item item : toInstall.values()) {
            ComponentSerializationSupport.serialize((String)"vmd-midp", (TypeDescriptor)item.getTypeDescriptor(), (PaletteDescriptor)item.getPaletteDescriptor(), item.getProperties(), item.getPresenters());
        }
    }

    private static void recursiveAdd(HashMap<String, Item> toInstall, Map<String, Item> allFoundComponents, Item item) {
        if (item == null) {
            return;
        }
        if (toInstall.containsKey(item.getFQN())) {
            return;
        }
        toInstall.put(item.getFQN(), item);
        ComponentInstaller.recursiveAdd(toInstall, allFoundComponents, allFoundComponents.get(item.getSuperFQN()));
    }

    public static Map<String, Item> search(final Project project) {
        final Object[] ret = new Object[1];
        ComponentSerializationSupport.runUnderDescriptorRegistryReadAccess((String)"vmd-midp", (Runnable)new Runnable(){

            @Override
            public void run() {
                ret[0] = ComponentInstaller.searchCore(project);
            }
        });
        return (Map)ret[0];
    }

    public static Map<String, Item> searchCore(Project project) {
        final ClasspathInfo info = MidpProjectSupport.getClasspathInfo(project);
        if (info == null) {
            return Collections.emptyMap();
        }
        final SourceGroup sourceGroup = MidpProjectSupport.getSourceGroup(project);
        final Set allHandles = info.getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.PREFIX, EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        final Map<String, ComponentDescriptor> registry = ComponentInstaller.resolveRegistryMap(project);
        final HashMap<String, Item> result = new HashMap<String, Item>();
        try {
            JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController parameter) throws Exception {
                    Iterator iterator;
                    HashSet<TypeElement> elements = new HashSet<TypeElement>();
                    for (ElementHandle handle : allHandles) {
                        TypeElement element = (TypeElement)handle.resolve((CompilationInfo)parameter);
                        if (element == null || element.getKind() != ElementKind.CLASS) continue;
                        elements.add(element);
                    }
                    while ((iterator = elements.iterator()).hasNext()) {
                        TypeElement element = (TypeElement)iterator.next();
                        ComponentInstaller.search(element, elements, registry, info, sourceGroup, result);
                    }
                }
            }, true);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return result;
    }

    private static Map<String, ComponentDescriptor> resolveRegistryMap(Project project) {
        final DescriptorRegistry registry = DescriptorRegistry.getDescriptorRegistry((String)"vmd-midp", (String)ProjectUtils.getProjectID((Project)project));
        final HashMap<String, ComponentDescriptor> registryMap = new HashMap<String, ComponentDescriptor>();
        registry.readAccess(new Runnable(){

            @Override
            public void run() {
                for (ComponentDescriptor descriptor : registry.getComponentDescriptors()) {
                    TypeID thisType = descriptor.getTypeDescriptor().getThisType();
                    String string = thisType.getString();
                    if (!ComponentInstaller.checkForJavaIdentifierCompliant(string) || !registry.isInHierarchy(ClassCD.TYPEID, thisType) || ClassCD.TYPEID.equals((Object)thisType)) continue;
                    registryMap.put(string, descriptor);
                }
            }
        });
        return registryMap;
    }

    private static boolean search(TypeElement element, Set<TypeElement> elements, Map<String, ComponentDescriptor> registry, ClasspathInfo info, SourceGroup sourceGroup, Map<String, Item> result) {
        if (element == null) {
            return false;
        }
        elements.remove(element);
        if (element.getKind() != ElementKind.CLASS) {
            return false;
        }
        Name tempQualifiedName = element.getQualifiedName();
        if (tempQualifiedName == null) {
            return false;
        }
        String fqn = tempQualifiedName.toString();
        ComponentDescriptor descriptor = registry.get(fqn);
        if (descriptor != null) {
            return true;
        }
        Item item = result.get(fqn);
        if (item != null) {
            return true;
        }
        TypeElement superElement = ComponentInstaller.getSuperElement(element);
        if (superElement == null) {
            return false;
        }
        if (!ComponentInstaller.search(superElement, elements, registry, info, sourceGroup, result)) {
            return false;
        }
        String superFQN = superElement.getQualifiedName().toString();
        if (!registry.containsKey(superFQN) && !result.containsKey(superFQN)) {
            return false;
        }
        boolean isAbstract = element.getModifiers().contains((Object)Modifier.ABSTRACT);
        boolean isFinal = element.getModifiers().contains((Object)Modifier.FINAL);
        FileObject file = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)element), (ClasspathInfo)info);
        boolean isInSource = file != null && sourceGroup != null && FileUtil.isParentOf((FileObject)sourceGroup.getRootFolder(), (FileObject)file);
        item = new Item(superFQN, fqn, isAbstract, isFinal, isInSource);
        item.addPresenter(new MidpAddImportPresenterSerializer());
        ComponentInstaller.inspectElement(item, element);
        result.put(fqn, item);
        return true;
    }

    private static boolean inspectElement(Item item, TypeElement clazz) {
        String fqn = clazz.getQualifiedName().toString();
        boolean hasConstructor = false;
        int constructorIndex = 1;
        for (Element element : clazz.getEnclosedElements()) {
            String name;
            String displayName;
            PropertyDescriptor property;
            ExecutableElement method;
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                method = (ExecutableElement)element;
                ArrayList<String> properties = new ArrayList<String>();
                int index = 1;
                for (VariableElement variableElement : method.getParameters()) {
                    property = MidpTypesConvertor.createPropertyDescriptorForParameter(fqn + "#" + constructorIndex + "#" + index, true, variableElement);
                    item.addProperty(property);
                    properties.add(property.getName());
                    displayName = NbBundle.getMessage(ComponentInstaller.class, (String)"NAME_ConstructorParam", (Object[])new Object[]{variableElement.getSimpleName(), constructorIndex, index, fqn});
                    item.addPresenter(new MidpPropertyPresenterSerializer(displayName, property));
                    ++index;
                }
                item.addPresenter(new MidpSetterPresenterSerializer(null, properties));
                continue;
            }
            if (element.getKind() != ElementKind.METHOD || !(name = (method = (ExecutableElement)element).getSimpleName().toString()).startsWith("set") || name.length() < 4 || !Character.isUpperCase(name.charAt(3))) continue;
            ArrayList<String> properties = new ArrayList<String>();
            List<? extends VariableElement> parameters = method.getParameters();
            if (parameters.size() != 1) continue;
            VariableElement variableElement = parameters.iterator().next();
            property = MidpTypesConvertor.createPropertyDescriptorForParameter(fqn + "#" + name, false, variableElement);
            item.addProperty(property);
            properties.add(property.getName());
            displayName = NbBundle.getMessage(ComponentInstaller.class, (String)"NAME_SetterParam", (Object)variableElement.getSimpleName(), (Object)name, (Object)fqn);
            item.addPresenter(new MidpPropertyPresenterSerializer(displayName, property));
            item.addPresenter(new MidpSetterPresenterSerializer(name, properties));
        }
        return hasConstructor;
    }

    private static TypeElement getSuperElement(TypeElement element) {
        TypeMirror superType = element.getSuperclass();
        if (superType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        return (TypeElement)((DeclaredType)superType).asElement();
    }

    private static boolean checkForJavaIdentifierCompliant(String fqn) {
        if (fqn == null || fqn.length() < 1) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(fqn.charAt(0))) {
            return false;
        }
        boolean dot = false;
        for (int index = 1; index < fqn.length(); ++index) {
            char c = fqn.charAt(index);
            if (Character.isJavaIdentifierPart(c)) {
                dot = false;
                continue;
            }
            if (c != '.') {
                return false;
            }
            if (dot) {
                return false;
            }
            dot = true;
        }
        return !dot;
    }

    public static class Item {
        private TypeDescriptor typeDescriptor;
        private PaletteDescriptor paletteDescriptor;
        private String superFQN;
        private String fqn;
        private boolean inSource;
        private ArrayList<PropertyDescriptor> properties = new ArrayList();
        private ArrayList<PresenterSerializer> presenters = new ArrayList();

        public Item(String superFQN, String fqn, boolean isAbstract, boolean isFinal, boolean inSource) {
            this.superFQN = superFQN;
            this.fqn = fqn;
            this.inSource = inSource;
            TypeID typeID = new TypeID(TypeID.Kind.COMPONENT, fqn);
            this.typeDescriptor = new TypeDescriptor(new TypeID(TypeID.Kind.COMPONENT, superFQN), typeID, !isAbstract, !isFinal);
            this.paletteDescriptor = new PaletteDescriptor("custom", MidpTypes.getSimpleClassName(typeID), fqn, "org/netbeans/modules/vmd/midp/resources/components/custom_component_16.png", "org/netbeans/modules/vmd/midp/resources/components/custom_component_32.png");
        }

        public String getSuperFQN() {
            return this.superFQN;
        }

        public String getFQN() {
            return this.fqn;
        }

        public boolean isInSource() {
            return this.inSource;
        }

        public TypeDescriptor getTypeDescriptor() {
            return this.typeDescriptor;
        }

        public PaletteDescriptor getPaletteDescriptor() {
            return this.paletteDescriptor;
        }

        public List<PropertyDescriptor> getProperties() {
            return this.properties;
        }

        public List<PresenterSerializer> getPresenters() {
            return this.presenters;
        }

        public void addPresenter(PresenterSerializer serializer) {
            this.presenters.add(serializer);
        }

        public void addProperty(PropertyDescriptor property) {
            this.properties.add(property);
        }
    }
}

