/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.general.Bitmask;
import org.netbeans.modules.vmd.midp.components.items.Constraints;
import org.netbeans.modules.vmd.midp.propertyeditors.Bundle;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorConstraints
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private CustomEditorConstraints customEditor;
    private JRadioButton radioButton;
    private int bitMask;
    private Constraints constraints;
    private HashMap<Integer, Bitmask.BitmaskItem> bits;

    private PropertyEditorConstraints() {
        super(NbBundle.getMessage(PropertyEditorConstraints.class, (String)"LBL_CONSTR_UCLABEL"));
        this.initMap();
        this.initElements(Collections.singleton(this));
    }

    public static final PropertyEditorConstraints createInstance() {
        return new PropertyEditorConstraints();
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorConstraints.class, (String)"LBL_CONSTR_STR"));
        this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorConstraints.class, (String)"ACSN_CONSTR_STR"));
        this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorConstraints.class, (String)"ACSD_CONSTR_STR"));
        this.customEditor = new CustomEditorConstraints();
    }

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.customEditor = null;
        this.radioButton = null;
    }

    private void combineMaskWithGuiName(Integer value, Bitmask.BitmaskItem bitmaskItem) {
        this.bits.put(value, bitmaskItem);
    }

    void initMap() {
        this.bits = new HashMap();
        this.constraints = new Constraints(0);
        this.combineMaskWithGuiName(0, this.constraints.getBitmaskItem(0));
        this.combineMaskWithGuiName(65536, this.constraints.getBitmaskItem(65536));
        this.combineMaskWithGuiName(2, this.constraints.getBitmaskItem(2));
        this.combineMaskWithGuiName(131072, this.constraints.getBitmaskItem(131072));
        this.combineMaskWithGuiName(1, this.constraints.getBitmaskItem(1));
        this.combineMaskWithGuiName(262144, this.constraints.getBitmaskItem(262144));
        this.combineMaskWithGuiName(3, this.constraints.getBitmaskItem(3));
        this.combineMaskWithGuiName(524288, this.constraints.getBitmaskItem(524288));
        this.combineMaskWithGuiName(4, this.constraints.getBitmaskItem(4));
        this.combineMaskWithGuiName(0x100000, this.constraints.getBitmaskItem(0x100000));
        this.combineMaskWithGuiName(524288, this.constraints.getBitmaskItem(524288));
        this.combineMaskWithGuiName(5, this.constraints.getBitmaskItem(5));
        this.combineMaskWithGuiName(0x200000, this.constraints.getBitmaskItem(0x200000));
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return true;
    }

    @Override
    public String getAsText() {
        String superText = super.getAsText();
        if (superText != null) {
            return superText;
        }
        if (this.constraints == null) {
            return null;
        }
        this.setConstant(MidpTypes.getInteger((PropertyValue)super.getValue()));
        return this.getBitmaskAsText();
    }

    private void setConstant(int bitmask) {
        this.constraints.setBitmask(bitmask);
        this.bitMask = bitmask;
    }

    private String getBitmaskAsText() {
        StringBuffer bitmaskAsTextRadioButton1 = new StringBuffer();
        StringBuffer separator = new StringBuffer(" | ");
        for (int intValue = 0; intValue <= 5; ++intValue) {
            if (!this.constraints.isSet(this.bits.get(intValue)) || this.bits.get(intValue).getAffectedBits() > 5) continue;
            bitmaskAsTextRadioButton1 = new StringBuffer(this.bits.get(intValue).getName());
            bitmaskAsTextRadioButton1.append(separator);
        }
        for (int intValue : this.bits.keySet()) {
            if (!this.constraints.isSet(this.bits.get(intValue)) || this.bits.get(intValue).getAffectedBits() <= 5) continue;
            bitmaskAsTextRadioButton1.append(this.bits.get(intValue).getName());
            bitmaskAsTextRadioButton1.append(separator);
        }
        bitmaskAsTextRadioButton1.deleteCharAt(bitmaskAsTextRadioButton1.lastIndexOf(separator.toString().trim()));
        return bitmaskAsTextRadioButton1.toString();
    }

    @Override
    public void setTextForPropertyValue(String text) {
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public void updateState(PropertyValue value) {
        if (this.isCurrentValueANull() || value == null) {
            this.customEditor.setBitmask(0);
        } else {
            this.customEditor.setBitmask(MidpTypes.getInteger(value));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue() {
        super.setValue((Object)MidpTypes.createIntegerValue(this.bitMask));
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
            this.customEditor = new CustomEditorConstraints();
        }
        return super.getCustomEditor();
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue();
        }
    }

    @Override
    public Boolean canEditAsText() {
        return false;
    }

    private class CustomEditorConstraints
    extends JPanel
    implements ItemListener {
        private Map<JToggleButton, Bitmask.BitmaskItem> radioButtonsMap = new HashMap<JToggleButton, Bitmask.BitmaskItem>();
        private Map<JToggleButton, Bitmask.BitmaskItem> checkBoxesMap = new HashMap<JToggleButton, Bitmask.BitmaskItem>();
        private List<JToggleButton> guiItems = new ArrayList<JToggleButton>();
        private JRadioButton anyRadioButton;
        private JCheckBox passwordCheckBox;

        public CustomEditorConstraints() {
            this.initComponents();
        }

        void cleanUp() {
            PropertyEditorConstraints.this.constraints = null;
            this.radioButtonsMap.clear();
            this.radioButtonsMap = null;
            this.checkBoxesMap.clear();
            this.checkBoxesMap = null;
            this.guiItems.clear();
            this.guiItems = null;
            this.anyRadioButton = null;
            this.passwordCheckBox = null;
            this.removeAll();
        }

        private void initComponents() {
            ButtonGroup buttonGroup = new ButtonGroup();
            this.setLayout(new GridLayout(6, 2));
            this.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_TEXTFIELDPE_NAME")));
            this.anyRadioButton = new JRadioButton(PropertyEditorConstraints.this.constraints.getBitmaskItem(0).getDisplayName());
            this.anyRadioButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_ANY"));
            buttonGroup.add(this.anyRadioButton);
            this.radioButtonsMap.put(this.anyRadioButton, PropertyEditorConstraints.this.constraints.getBitmaskItem(0));
            this.guiItems.add(this.anyRadioButton);
            this.add(this.anyRadioButton);
            this.anyRadioButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintAny"));
            this.anyRadioButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintAny"));
            this.passwordCheckBox = new JCheckBox(PropertyEditorConstraints.this.constraints.getBitmaskItem(65536).getDisplayName());
            this.passwordCheckBox.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_PASSWORD"));
            this.checkBoxesMap.put(this.passwordCheckBox, PropertyEditorConstraints.this.constraints.getBitmaskItem(65536));
            this.guiItems.add(this.passwordCheckBox);
            this.add(this.passwordCheckBox);
            this.passwordCheckBox.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintPasswd"));
            this.passwordCheckBox.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintPasswd"));
            JToggleButton guiItem = new JRadioButton(PropertyEditorConstraints.this.constraints.getBitmaskItem(2).getDisplayName());
            guiItem.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_NUMERIC"));
            buttonGroup.add(guiItem);
            this.radioButtonsMap.put(guiItem, PropertyEditorConstraints.this.constraints.getBitmaskItem(2));
            this.guiItems.add(guiItem);
            this.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintNum"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintNum"));
            guiItem = new JCheckBox(PropertyEditorConstraints.this.constraints.getBitmaskItem(131072).getDisplayName());
            guiItem.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_UNEDITABLE"));
            this.checkBoxesMap.put(guiItem, PropertyEditorConstraints.this.constraints.getBitmaskItem(131072));
            this.guiItems.add(guiItem);
            this.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintUnedit"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintUnedit"));
            guiItem = new JRadioButton(PropertyEditorConstraints.this.constraints.getBitmaskItem(1).getDisplayName());
            guiItem.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_EMAIL"));
            buttonGroup.add(guiItem);
            this.radioButtonsMap.put(guiItem, PropertyEditorConstraints.this.constraints.getBitmaskItem(1));
            this.guiItems.add(guiItem);
            this.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintEmail"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintEmail"));
            guiItem = new JCheckBox(PropertyEditorConstraints.this.constraints.getBitmaskItem(262144).getDisplayName());
            guiItem.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_SENSITIVE"));
            this.checkBoxesMap.put(guiItem, PropertyEditorConstraints.this.constraints.getBitmaskItem(262144));
            this.guiItems.add(guiItem);
            this.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintSensetive"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintSensetive"));
            guiItem = new JRadioButton(PropertyEditorConstraints.this.constraints.getBitmaskItem(3).getDisplayName());
            guiItem.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_PHONE"));
            buttonGroup.add(guiItem);
            this.radioButtonsMap.put(guiItem, PropertyEditorConstraints.this.constraints.getBitmaskItem(3));
            this.guiItems.add(guiItem);
            this.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintPhone"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintPhone"));
            guiItem = new JCheckBox(PropertyEditorConstraints.this.constraints.getBitmaskItem(524288).getDisplayName());
            guiItem.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_NONPREDICTIVE"));
            this.checkBoxesMap.put(guiItem, PropertyEditorConstraints.this.constraints.getBitmaskItem(524288));
            this.guiItems.add(guiItem);
            this.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintNonPredictive"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintNonPredictive"));
            guiItem = new JRadioButton(PropertyEditorConstraints.this.constraints.getBitmaskItem(4).getDisplayName());
            guiItem.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_URL"));
            buttonGroup.add(guiItem);
            this.radioButtonsMap.put(guiItem, PropertyEditorConstraints.this.constraints.getBitmaskItem(4));
            this.guiItems.add(guiItem);
            this.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintUrl"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintUrl"));
            guiItem = new JCheckBox(PropertyEditorConstraints.this.constraints.getBitmaskItem(0x100000).getDisplayName());
            guiItem.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_CAPS_WORD"));
            this.checkBoxesMap.put(guiItem, PropertyEditorConstraints.this.constraints.getBitmaskItem(0x100000));
            this.guiItems.add(guiItem);
            this.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintInitial_CAPS_WORD"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintInitial_CAPS_WORD"));
            guiItem = new JRadioButton(PropertyEditorConstraints.this.constraints.getBitmaskItem(5).getDisplayName());
            guiItem.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_DECIMAL"));
            buttonGroup.add(guiItem);
            this.radioButtonsMap.put(guiItem, PropertyEditorConstraints.this.constraints.getBitmaskItem(5));
            this.guiItems.add(guiItem);
            this.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintDec"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintDec"));
            guiItem = new JCheckBox(PropertyEditorConstraints.this.constraints.getBitmaskItem(0x200000).getDisplayName());
            guiItem.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_CAPS_SENTENCE"));
            this.checkBoxesMap.put(guiItem, PropertyEditorConstraints.this.constraints.getBitmaskItem(0x200000));
            this.guiItems.add(guiItem);
            this.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintInitial_CAPS_SENTENCE"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintInitial_CAPS_SENTENCE"));
            this.setGui();
            for (JToggleButton button : this.guiItems) {
                button.addItemListener(this);
            }
        }

        public void setBitmask(int bitmask) {
            for (JToggleButton button : this.guiItems) {
                button.removeItemListener(this);
            }
            PropertyEditorConstraints.this.constraints.setBitmask(bitmask);
            this.setGui();
            for (JToggleButton button : this.guiItems) {
                button.addItemListener(this);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            PropertyEditorConstraints.this.constraints.setBitmask(0);
            for (JToggleButton button : this.radioButtonsMap.keySet()) {
                if (!button.isSelected()) continue;
                PropertyEditorConstraints.this.constraints.addToBitmask(this.radioButtonsMap.get(button), true);
            }
            for (JToggleButton button : this.checkBoxesMap.keySet()) {
                if (!button.isSelected()) continue;
                PropertyEditorConstraints.this.constraints.addToBitmask(this.checkBoxesMap.get(button), true);
            }
            PropertyEditorConstraints.this.bitMask = PropertyEditorConstraints.this.constraints.getBitmask();
        }

        private void setGui() {
            int radioButtonBitmask = 0;
            for (JToggleButton button : this.radioButtonsMap.keySet()) {
                if (!PropertyEditorConstraints.this.constraints.isSet(this.radioButtonsMap.get(button)) || radioButtonBitmask > this.radioButtonsMap.get(button).getAffectedBits()) continue;
                radioButtonBitmask = this.radioButtonsMap.get(button).getAffectedBits();
                button.setSelected(true);
            }
            for (JToggleButton button : this.checkBoxesMap.keySet()) {
                if (!PropertyEditorConstraints.this.constraints.isSet(this.checkBoxesMap.get(button))) continue;
                button.setSelected(true);
            }
        }
    }
}

