/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.screen.display.DisplayableDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.GaugeDisplayPresenterElement;
import org.netbeans.modules.vmd.midp.screen.display.ScreenFileObjectListener;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenStringPropertyEditor;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class AlertDisplayPresenter
extends DisplayableDisplayPresenter {
    private static final String ICON_BROKEN_PATH = "org/netbeans/modules/vmd/midp/resources/screen/broken-image.png";
    private static final Icon ICON_BROKEN = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/screen/broken-image.png", (boolean)false);
    private JLabel imageLabel = new JLabel();
    private JLabel stringLabel;
    private ScreenFileObjectListener imageFileListener;
    private FileObject imageFileObject;
    private GaugeDisplayPresenterElement gauge;
    private JPanel panel;
    private GridBagConstraints constraints;

    public AlertDisplayPresenter() {
        this.imageLabel.setHorizontalAlignment(0);
        this.stringLabel = new JLabel();
        this.stringLabel.setHorizontalAlignment(0);
        JPanel contentPanel = this.getPanel().getContentPanel();
        contentPanel.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.constraints.fill = 2;
        this.constraints.gridx = 0;
        this.constraints.gridy = -1;
        this.constraints.anchor = 10;
        contentPanel.add((Component)this.imageLabel, this.constraints);
        this.constraints.anchor = 18;
        contentPanel.add((Component)this.stringLabel, this.constraints);
    }

    @Override
    public void reload(ScreenDeviceInfo deviceInfo) {
        super.reload(deviceInfo);
        PropertyValue value = this.getComponent().readProperty("string");
        if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind())) {
            String text = MidpTypes.getString(value);
            if (text == null) {
                this.stringLabel.setText(NbBundle.getMessage(AlertDisplayPresenter.class, (String)"DISP_text_not_specified"));
            } else if (text.length() == 0) {
                this.stringLabel.setText(NbBundle.getMessage(AlertDisplayPresenter.class, (String)"DISP_text_is_empty"));
            } else {
                this.stringLabel.setText(text);
            }
        } else {
            this.stringLabel.setText(NbBundle.getMessage(AlertDisplayPresenter.class, (String)"DISP_text_is_usercode"));
        }
        value = this.getComponent().readProperty("image");
        if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind())) {
            DesignComponent imageComponent = value.getComponent();
            String path = null;
            if (imageComponent != null) {
                path = (String)imageComponent.readProperty("resourcePath").getPrimitiveValue();
            }
            Icon icon = ScreenSupport.getIconFromImageComponent(imageComponent);
            this.imageFileObject = ScreenSupport.getFileObjectFromImageComponent(imageComponent);
            if (this.imageFileObject != null) {
                this.imageLabel.setText(null);
                this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
                this.imageFileListener = new ScreenFileObjectListener(this.getRelatedComponent(), imageComponent, "resourcePath");
                this.imageFileObject.addFileChangeListener((FileChangeListener)this.imageFileListener);
            }
            if (icon != null) {
                this.imageLabel.setIcon(icon);
            } else if (path != null) {
                this.imageLabel.setIcon(ICON_BROKEN);
            } else {
                this.imageLabel.setIcon(null);
                this.imageLabel.setText(NbBundle.getMessage(AlertDisplayPresenter.class, (String)"DISP_image_not_specified"));
            }
        } else {
            this.imageLabel.setText(NbBundle.getMessage(AlertDisplayPresenter.class, (String)"DISP_image_is_usercode"));
        }
        DesignComponent indicator = this.getComponent().readProperty("indicator").getComponent();
        if (indicator != null) {
            this.gauge = new GaugeDisplayPresenterElement();
            if (this.panel == null) {
                this.panel = new JPanel(){

                    @Override
                    public void paint(Graphics g) {
                        super.paint(g);
                        AlertDisplayPresenter.this.gauge.setPanel(this);
                        AlertDisplayPresenter.this.gauge.paintGauge(g);
                    }
                };
                this.panel.setOpaque(false);
                this.panel.setPreferredSize(new Dimension(200, 40));
                this.panel.repaint();
                this.panel.revalidate();
                this.constraints.anchor = 10;
                this.getPanel().getContentPanel().add((Component)this.panel, this.constraints);
            }
            this.gauge.setSize(this.panel.getSize());
            this.gauge.setInteractive(MidpTypes.getBoolean(indicator.readProperty("interactive")));
            int maxValue = MidpTypes.getInteger(indicator.readProperty("maxValue"));
            if (maxValue < 0) {
                maxValue = 1;
            }
            this.gauge.setMaxValue(maxValue);
            int intValue = MidpTypes.getInteger(indicator.readProperty("value"));
            if (intValue < 0) {
                intValue = 0;
            } else if (intValue > maxValue) {
                intValue = maxValue;
            }
            this.gauge.setValue(intValue);
            this.panel.repaint();
        } else if (this.panel != null) {
            this.getPanel().getContentPanel().remove(this.panel);
            this.panel = null;
            this.gauge = null;
        }
    }

    @Override
    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ArrayList<ScreenPropertyDescriptor> descriptors = new ArrayList<ScreenPropertyDescriptor>(super.getPropertyDescriptors());
        ResourcePropertyEditor imagePropertyEditor = new ResourcePropertyEditor("image", this.getComponent());
        descriptors.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.imageLabel, (ScreenPropertyEditor)imagePropertyEditor));
        descriptors.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.stringLabel, (ScreenPropertyEditor)new ScreenStringPropertyEditor("string")));
        DesignComponent indicator = this.getComponent().readProperty("indicator").getComponent();
        ResourcePropertyEditor gaugePropertyEditor = new ResourcePropertyEditor("value", indicator);
        if (indicator != null) {
            descriptors.add(new ScreenPropertyDescriptor(indicator, (JComponent)this.panel, (ScreenPropertyEditor)gaugePropertyEditor));
        }
        return descriptors;
    }

    protected void notifyDetached(DesignComponent component) {
        if (this.imageFileObject != null && this.imageFileListener != null) {
            this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
        }
        this.imageFileObject = null;
        this.imageFileListener = null;
    }
}

