/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.screen.display.DisplayableDisplayPanel;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenStringPropertyEditor;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class DisplayableDisplayPresenter
extends ScreenDisplayPresenter {
    private static final Image BATTERY = ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/midp/screen/display/resources/battery.png");
    private static final Image SIGNAL = ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/midp/screen/display/resources/signal.png");
    private DisplayableDisplayPanel panel = new DisplayableDisplayPanel(this);

    public DisplayableDisplayPresenter() {
        this.panel.getBattery().setIcon(new ImageIcon(BATTERY));
        this.panel.getSignal().setIcon(new ImageIcon(SIGNAL));
        ScreenSupport.addKeyboardSupport(this);
    }

    public DisplayableDisplayPresenter(Image image) {
        this();
        this.panel.add(new JLabel(new ImageIcon(image)));
    }

    public boolean isTopLevelDisplay() {
        return true;
    }

    public Collection<DesignComponent> getChildren() {
        return Collections.emptyList();
    }

    public JComponent getView() {
        return this.panel;
    }

    protected DisplayableDisplayPanel getPanel() {
        return this.panel;
    }

    public Shape getSelectionShape() {
        return new Rectangle(this.panel.getSize());
    }

    public void reload(ScreenDeviceInfo deviceInfo) {
        String tickerText = null;
        if (this.getComponent().readProperty("ticker").getKind() == PropertyValue.Kind.USERCODE) {
            tickerText = NbBundle.getMessage(DisplayableDisplayPresenter.class, (String)"DISP_user_code");
        } else {
            DesignComponent ticker = this.getComponent().readProperty("ticker").getComponent();
            if (ticker != null) {
                PropertyValue value = ticker.readProperty("string");
                if (value.getKind() == PropertyValue.Kind.USERCODE) {
                    tickerText = NbBundle.getMessage(DisplayableDisplayPresenter.class, (String)"DISP_ticker_string_user_code");
                } else {
                    tickerText = MidpValueSupport.getHumanReadableString(value);
                    if (tickerText == null || tickerText.length() == 0) {
                        tickerText = NbBundle.getMessage(DisplayableDisplayPresenter.class, (String)"DISP_empty_ticker_string");
                    }
                }
            }
        }
        this.panel.getTicker().setText(tickerText);
        this.panel.getTitle().setText(MidpValueSupport.getHumanReadableString(this.getComponent().readProperty("title")));
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        DesignComponent ticker = this.getComponent().readProperty("ticker").getComponent();
        Object tickerEditor = ticker == null ? new ResourcePropertyEditor("ticker", this.getComponent()) : new ScreenStringPropertyEditor("string", "ticker", 0);
        return Arrays.asList(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.panel.getTitle(), (ScreenPropertyEditor)new ScreenStringPropertyEditor("title", 0)), new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.panel.getTicker(), (ScreenPropertyEditor)tickerEditor));
    }
}

