/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptPresenter;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.model.common.DesignComponentDataFlavorSupport;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.midp.screen.display.ScreenMoveArrayAcceptSuggestion;

public class ScreenMoveArrayAcceptPresenter
extends AcceptPresenter {
    private String arrayPropertyName;
    private TypeID arrayType;

    public ScreenMoveArrayAcceptPresenter(String arrayPropertyName, TypeID arrayType) {
        super(AcceptPresenter.Kind.TRANSFERABLE);
        this.arrayPropertyName = arrayPropertyName;
        this.arrayType = arrayType;
    }

    public boolean isAcceptable(Transferable transferable, AcceptSuggestion suggestion) {
        if (!transferable.isDataFlavorSupported(DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR)) {
            return false;
        }
        if (this.getComponent().getDocument().getSelectedComponents().size() > 1) {
            return false;
        }
        DesignComponent componentTrans = DesignComponentDataFlavorSupport.getTransferableDesignComponent((Transferable)transferable);
        if (!(suggestion instanceof ScreenMoveArrayAcceptSuggestion)) {
            return false;
        }
        return componentTrans.getParentComponent() == this.getComponent().getParentComponent();
    }

    public ComponentProducer.Result accept(Transferable transferable, AcceptSuggestion suggestion) {
        DesignComponent componentTrans = DesignComponentDataFlavorSupport.getTransferableDesignComponent((Transferable)transferable);
        DesignComponent parentComponent = this.getComponent().getParentComponent();
        List array = parentComponent.readProperty(this.arrayPropertyName).getArray();
        if (array == null || array.size() < 1) {
            return super.accept(transferable, suggestion);
        }
        ArrayList<PropertyValue> newArray = new ArrayList<PropertyValue>(array);
        PropertyValue movedValue = null;
        int componentTransIndex = -1;
        int componentIndex = -1;
        for (PropertyValue value : array) {
            if (value.getComponent().equals(componentTrans)) {
                movedValue = value;
                componentTransIndex = array.indexOf(value);
            }
            if (!value.getComponent().equals(this.getComponent())) continue;
            componentIndex = array.indexOf(value);
        }
        ScreenDeviceInfo.Edge verticalPosition = ((ScreenMoveArrayAcceptSuggestion)suggestion).getVerticalPosition();
        newArray.remove(componentTransIndex);
        if (verticalPosition == ScreenDeviceInfo.Edge.TOP && componentTransIndex + 1 != componentIndex) {
            newArray.add(componentIndex, movedValue);
        } else if (verticalPosition == ScreenDeviceInfo.Edge.BOTTOM) {
            if (componentTransIndex > componentIndex) {
                newArray.add(componentIndex + 1, movedValue);
            } else {
                newArray.add(componentIndex, movedValue);
            }
        } else {
            return super.accept(transferable, suggestion);
        }
        DesignComponent dragComponent = DesignComponentDataFlavorSupport.getTransferableDesignComponent((Transferable)transferable);
        if (dragComponent == null) {
            return super.accept(transferable, suggestion);
        }
        parentComponent.writeProperty(this.arrayPropertyName, PropertyValue.createArray((TypeID)this.arrayType, newArray));
        return new ComponentProducer.Result(new DesignComponent[]{dragComponent});
    }
}

