/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display.property;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.netbeans.modules.vmd.api.io.PopupUtil;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.util.NbBundle;

public class ScreenTextAreaPropertyEditor
implements ScreenPropertyEditor {
    private String propertyName;

    public ScreenTextAreaPropertyEditor(String propertyName) {
        assert (propertyName != null);
        this.propertyName = propertyName;
    }

    public JComponent createEditorComponent(ScreenPropertyDescriptor property) {
        StringTextArea editor = new StringTextArea(property);
        editor.setMinimumSize(new Dimension(128, 21));
        PropertyValue value = property.getRelatedComponent().readProperty(this.propertyName);
        String string = MidpTypes.getString(value);
        editor.setText(string != null ? string : "");
        editor.setCaretPosition(editor.getDocument().getLength());
        return editor;
    }

    public Insets getEditorComponentInsets(JComponent editorComponent) {
        return editorComponent.getBorder().getBorderInsets(editorComponent);
    }

    private class StringTextArea
    extends JTextArea
    implements KeyListener,
    FocusListener {
        private ScreenPropertyDescriptor property;

        public StringTextArea(ScreenPropertyDescriptor property) {
            this.property = property;
            this.setToolTipText(NbBundle.getMessage(ScreenTextAreaPropertyEditor.class, (String)"TTIP_ScreenTextAreaPE"));
            this.addKeyListener(this);
            this.addFocusListener(this);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() != '\n' || (e.getModifiersEx() & 0x80) == 0) {
                return;
            }
            this.property.getRelatedComponent().getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyValue value = MidpTypes.createStringValue(StringTextArea.this.getText());
                    StringTextArea.this.property.getRelatedComponent().writeProperty(ScreenTextAreaPropertyEditor.this.propertyName, value);
                }
            });
            PopupUtil.hidePopup();
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            this.property.getRelatedComponent().getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyValue value = MidpTypes.createStringValue(StringTextArea.this.getText());
                    StringTextArea.this.property.getRelatedComponent().writeProperty(ScreenTextAreaPropertyEditor.this.propertyName, value);
                }
            });
            PopupUtil.hidePopup();
        }
    }
}

