/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.netbeans.modules.web.jsfapi.api.Tag;

public final class HtmlSourceTask
extends ParserResultTask<HtmlParserResult> {
    private static final String CSS_CLASS_MAP_PROPERTY_KEY = "cssClassTagAttrMap";
    private static final String HTML_FACELETS_LIB_NS = "http://java.sun.com/jsf/html";
    private static final String STYLE_CLASS_ATTR_NAME = "styleClass";

    public int getPriority() {
        return 50;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public void run(HtmlParserResult result, SchedulerEvent event) {
        String prefix;
        Source source = result.getSnapshot().getSource();
        if (!source.getMimeType().equals("text/xhtml")) {
            return;
        }
        JsfSupportImpl sup = JsfSupportImpl.findFor(source);
        if (sup == null) {
            return;
        }
        Document doc = result.getSnapshot().getSource().getDocument(true);
        if (doc == null) {
            return;
        }
        InputAttributes inputAttributes = (InputAttributes)doc.getProperty(InputAttributes.class);
        if (inputAttributes == null) {
            inputAttributes = new InputAttributes();
            doc.putProperty(InputAttributes.class, inputAttributes);
        }
        if ((prefix = (String)result.getNamespaces().get(HTML_FACELETS_LIB_NS)) != null) {
            HashMap<String, List<String>> cssClassTagAttrMap = new HashMap<String, List<String>>();
            Library lib = sup.getLibrary(HTML_FACELETS_LIB_NS);
            if (lib != null) {
                Collection components = lib.getComponents();
                for (LibraryComponent comp : components) {
                    Tag tag = comp.getTag();
                    if ("dataTable".equals(tag.getName())) {
                        cssClassTagAttrMap.put(prefix + ":" + tag.getName(), Arrays.asList(STYLE_CLASS_ATTR_NAME, "headerClass", "footerClass", "rowClasses", "columnClasses", "captionClass"));
                        continue;
                    }
                    if (tag.getAttribute(STYLE_CLASS_ATTR_NAME) == null) continue;
                    cssClassTagAttrMap.put(prefix + ":" + tag.getName(), Collections.singletonList(STYLE_CLASS_ATTR_NAME));
                }
            }
            inputAttributes.setValue(HTMLTokenId.language(), (Object)CSS_CLASS_MAP_PROPERTY_KEY, cssClassTagAttrMap, true);
        } else {
            inputAttributes.setValue(HTMLTokenId.language(), (Object)CSS_CLASS_MAP_PROPERTY_KEY, null, true);
        }
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            String mimeType = snapshot.getMimeType();
            if (mimeType.equals("text/html")) {
                return Collections.singletonList(new HtmlSourceTask());
            }
            return Collections.EMPTY_LIST;
        }
    }
}

