/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.JsfIndexSupport;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JsfBinaryIndexer
extends BinaryIndexer {
    static final String INDEXER_NAME = "jsfBinary";
    static final int INDEX_VERSION = 8;
    private static final Logger LOGGER = Logger.getLogger(JsfBinaryIndexer.class.getSimpleName());

    protected void index(Context context) {
        LOGGER.log(Level.FINE, "indexing {0}", context.getRoot());
        if (context.getRoot() == null) {
            return;
        }
        this.processTlds(context);
        this.processFaceletsLibraryDescriptors(context);
        this.processFaceletsCompositeLibraries(context);
    }

    private void processTlds(Context context) {
        FileObject root = context.getRoot();
        for (FileObject file : JsfBinaryIndexer.findLibraryDescriptors(root, ".tld")) {
            try {
                String namespace = FaceletsLibraryDescriptor.parseNamespace(file.getInputStream(), "taglib", "uri");
                if (namespace == null) continue;
                JsfIndexSupport.indexTagLibraryDescriptor(context, file, namespace);
                LOGGER.log(Level.FINE, "The file {0} indexed as a TLD (namespace={1})", new Object[]{file, namespace});
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void processFaceletsLibraryDescriptors(Context context) {
        FileObject root = context.getRoot();
        for (FileObject file : JsfBinaryIndexer.findLibraryDescriptors(root, ".taglib.xml")) {
            try {
                String namespace = FaceletsLibraryDescriptor.parseNamespace(file.getInputStream());
                if (namespace == null) continue;
                JsfIndexSupport.indexFaceletsLibraryDescriptor(context, file, namespace);
                LOGGER.log(Level.FINE, "The file {0} indexed as a Facelets Library Descriptor", file);
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void processFaceletsCompositeLibraries(Context context) {
        FileObject resourcesFolder = context.getRoot().getFileObject("META-INF/resources");
        if (resourcesFolder != null) {
            LOGGER.log(Level.FINE, "Composite Libraries Scan: META-INF/resources folder found");
            try {
                Enumeration folders = resourcesFolder.getFolders(false);
                final IndexingSupport sup = IndexingSupport.getInstance((Context)context);
                final JsfPageModelFactory compositeComponentModelFactory = JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class);
                while (folders.hasMoreElements()) {
                    FileObject folder = (FileObject)folders.nextElement();
                    for (final FileObject file : folder.getChildren()) {
                        if (!file.getExt().equalsIgnoreCase("xhtml")) continue;
                        LOGGER.log(Level.FINE, "Composite Libraries Scan: found {0}", file);
                        Source source = Source.create((FileObject)file);
                        try {
                            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                                public void run(ResultIterator resultIterator) throws Exception {
                                    for (Embedding e : resultIterator.getEmbeddings()) {
                                        HtmlParserResult result;
                                        CompositeComponentModel ccmodel;
                                        if (!e.getMimeType().equals("text/html") || (ccmodel = (CompositeComponentModel)compositeComponentModelFactory.getModel(result = (HtmlParserResult)resultIterator.getResultIterator(e).getParserResult())) == null) continue;
                                        IndexDocument doc = sup.createDocument(file);
                                        ccmodel.storeToIndex(doc);
                                        sup.addDocument(doc);
                                        LOGGER.log(Level.FINE, "Composite Libraries Scan: Model created for file {0}", file);
                                    }
                                }
                            });
                        }
                        catch (ParseException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static Collection<FileObject> findLibraryDescriptors(FileObject classpathRoot, String suffix) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        Enumeration fos = classpathRoot.getChildren(true);
        while (fos.hasMoreElements()) {
            FileObject file = (FileObject)fos.nextElement();
            if (!file.getNameExt().toLowerCase(Locale.US).endsWith(suffix)) continue;
            files.add(file);
        }
        return files;
    }

    public static class Factory
    extends BinaryIndexerFactory {
        public BinaryIndexer createIndexer() {
            return new JsfBinaryIndexer();
        }

        public void rootsRemoved(Iterable<? extends URL> removedRoots) {
        }

        public boolean scanStarted(Context context) {
            try {
                return IndexingSupport.getInstance((Context)context).isValid();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }

        public String getIndexerName() {
            return JsfBinaryIndexer.INDEXER_NAME;
        }

        public int getIndexVersion() {
            return 8;
        }
    }
}

