/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.io.serialization;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DocumentErrorHandler {
    private List<String> errors = new ArrayList<String>();
    private List<String> warnings = new ArrayList<String>();

    public DocumentErrorHandler addError(String error) {
        if (error == null) {
            throw new IllegalArgumentException();
        }
        this.errors.add(error);
        return this;
    }

    public DocumentErrorHandler addError(String pattern, Object ... strings) {
        if (pattern == null || strings == null) {
            throw new IllegalArgumentException();
        }
        this.errors.add(MessageFormat.format(pattern, strings));
        return this;
    }

    public DocumentErrorHandler addWarning(String warning) {
        if (warning == null) {
            throw new IllegalArgumentException();
        }
        this.warnings.add(warning);
        return this;
    }

    public DocumentErrorHandler addWarning(String pattern, Object ... strings) {
        if (pattern == null || strings == null) {
            throw new IllegalArgumentException();
        }
        this.warnings.add(MessageFormat.format(pattern, strings));
        return this;
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public List<String> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }
}

