/*
 * Copyright (c) 2007 Mozilla Foundation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a 
 * copy of this software and associated documentation files (the "Software"), 
 * to deal in the Software without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, 
 * and/or sell copies of the Software, and to permit persons to whom the 
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 */

package nu.validator.messages.types;

public abstract class MessageType {
    
    public static final MessageType ERROR = new Error();
    
    public static final MessageType FATAL = new Fatal();
    
    public static final MessageType INFO = new Info();
    
    public static final MessageType INTERNAL = new Internal();

    public static final MessageType IO = new Io();
    
    public static final MessageType NON_DOCUMENT = new NonDocumentError();
    
    public static final MessageType SCHEMA = new Schema();
    
    public static final MessageType WARNING = new Warning();
    
    private final String flatType;

    public MessageType() {
        this.flatType = getSuperType() + (getSubType() == null ? "" : " " + getSubType());
    }
    
    public abstract char[] getPresentationName();
    
    public abstract String getSuperType();
    
    public String getSubType() {
        return null;
    }

    /**
     * Returns the flatType.
     * 
     * @return the flatType
     */
    public String getFlatType() {
        return flatType;
    }
}
