/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support.lang;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.apt.impl.support.lang.APTBaseLanguageFilter;
import org.netbeans.modules.cnd.apt.impl.support.lang.APTFortranFilter;
import org.netbeans.modules.cnd.apt.impl.support.lang.APTGnuCFilter;
import org.netbeans.modules.cnd.apt.impl.support.lang.APTGnuCppFilter;
import org.netbeans.modules.cnd.apt.impl.support.lang.APTStdCFilter;
import org.netbeans.modules.cnd.apt.impl.support.lang.APTStdCppFilter;
import org.netbeans.modules.cnd.apt.support.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public class APTLanguageSupportImpl {
    private static Map<String, APTLanguageFilter> langFilters = new HashMap<String, APTLanguageFilter>();

    private APTLanguageSupportImpl() {
    }

    public static APTLanguageFilter getFilter(String lang) {
        APTLanguageFilter filter = langFilters.get(lang);
        if (filter == null && (filter = APTLanguageSupportImpl.createFilter(lang)) != null) {
            APTLanguageSupportImpl.addFilter(lang, filter);
        }
        return filter;
    }

    public static void addFilter(String lang, APTLanguageFilter filter) {
        langFilters.put(lang, filter);
    }

    private static APTLanguageFilter createFilter(String lang) {
        APTBaseLanguageFilter filter = null;
        if (lang.equalsIgnoreCase("Std C Language")) {
            filter = new APTStdCFilter();
        } else if (lang.equalsIgnoreCase("Std C++ Language")) {
            filter = new APTStdCppFilter();
        } else if (lang.equalsIgnoreCase("Gnu C Language")) {
            filter = new APTGnuCFilter();
        } else if (lang.equalsIgnoreCase("Gnu C++ Language")) {
            filter = new APTGnuCppFilter();
        } else if (lang.equalsIgnoreCase("Fortran Language")) {
            filter = new APTFortranFilter();
        } else {
            APTUtils.LOG.warning("unsupported language " + lang);
        }
        return filter;
    }
}

