/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.openide.filesystems.FileSystem;
import org.openide.util.Parameters;

public final class APTFileCacheManager {
    private static Map<FileSystem, APTFileCacheManager> managers = new WeakHashMap<FileSystem, APTFileCacheManager>();
    private Reference<ConcurrentMap<CharSequence, ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry>>> refAptCaches = new SoftReference<Object>(null);
    private ConcurrentMap<CharSequence, Reference<ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry>>> file2AptCacheRef = new ConcurrentHashMap<CharSequence, Reference<ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry>>>();
    private final Object aptCachesLock = new Lock();

    private APTFileCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static APTFileCacheManager getInstance(FileSystem fs) {
        Parameters.notNull((CharSequence)"null file system", (Object)fs);
        Class<APTFileCacheManager> clazz = APTFileCacheManager.class;
        synchronized (APTFileCacheManager.class) {
            APTFileCacheManager manager = managers.get(fs);
            if (manager == null) {
                manager = new APTFileCacheManager();
                managers.put(fs, manager);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"DLS"})
    private ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> getAPTCache(CharSequence file, Boolean createAndClean) {
        Reference prev;
        ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> out;
        if (createAndClean == null) {
            Reference removed = (Reference)this.file2AptCacheRef.remove(file);
            return null;
        }
        SoftReference ref2fileCache = (SoftReference)this.file2AptCacheRef.get(file);
        ConcurrentHashMap<APTIncludeHandler.State, APTFileCacheEntry> concurrentHashMap = out = ref2fileCache == null ? null : (ConcurrentHashMap<APTIncludeHandler.State, APTFileCacheEntry>)((Reference)ref2fileCache).get();
        if (out == null && (prev = (Reference)this.file2AptCacheRef.putIfAbsent(file, ref2fileCache = new SoftReference(out = new ConcurrentHashMap<APTIncludeHandler.State, APTFileCacheEntry>()))) != null) {
            ConcurrentMap prevCache = (ConcurrentMap)prev.get();
            if (prevCache != null) {
                out = prevCache;
            } else {
                Object object = this.aptCachesLock;
                synchronized (object) {
                    this.file2AptCacheRef.remove(file, prev);
                    boolean add = false;
                    prev = this.file2AptCacheRef.putIfAbsent(file, ref2fileCache);
                    if (prev != null) {
                        prevCache = (ConcurrentMap)prev.get();
                        if (prevCache != null) {
                            out = prevCache;
                        } else {
                            add = true;
                        }
                    }
                    if (add) {
                        this.file2AptCacheRef.put(file, ref2fileCache);
                    }
                }
            }
        }
        assert (out != null);
        if (Boolean.TRUE.equals(createAndClean)) {
            out.clear();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> getAPTCache2(CharSequence file, boolean clean) {
        ConcurrentMap prev;
        ConcurrentMap<CharSequence, ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry>> cache;
        Object object = this.aptCachesLock;
        synchronized (object) {
            cache = this.refAptCaches.get();
            if (cache == null || clean) {
                cache = new ConcurrentHashMap<CharSequence, ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry>>();
                this.refAptCaches = new SoftReference<ConcurrentMap<CharSequence, ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry>>>(cache);
            }
        }
        ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> out = (ConcurrentHashMap<APTIncludeHandler.State, APTFileCacheEntry>)cache.get(file);
        if (out == null && (prev = (ConcurrentMap)cache.putIfAbsent(file, out = new ConcurrentHashMap<APTIncludeHandler.State, APTFileCacheEntry>())) != null) {
            out = prev;
        }
        if (clean) {
            out.clear();
        }
        return out;
    }

    public APTFileCacheEntry getEntry(CharSequence file, APTPreprocHandler preprocHandler, Boolean createExclusiveIfAbsent) {
        APTIncludeHandler.State key = APTFileCacheManager.getKey(preprocHandler);
        ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> cache = this.getAPTCache(file, Boolean.FALSE);
        APTFileCacheEntry out = (APTFileCacheEntry)cache.get(key);
        if (createExclusiveIfAbsent != null) {
            if (out == null) {
                if (Boolean.TRUE.equals(createExclusiveIfAbsent)) {
                    out = APTFileCacheEntry.createSerialEntry(file);
                } else {
                    out = APTFileCacheEntry.createConcurrentEntry(file);
                    APTFileCacheEntry prev = cache.putIfAbsent(key, out);
                    if (prev != null) {
                        out = prev;
                    }
                }
            } else if (APTTraceFlags.TRACE_APT_CACHE) {
                System.err.printf("APT CACHE for %s\nsize %d, key: %s\ncache state:%s\n", file, cache.size(), "", "");
            }
        }
        assert (createExclusiveIfAbsent == null || out != null);
        return out;
    }

    public void setAPTCacheEntry(CharSequence absPath, APTPreprocHandler preprocHandler, APTFileCacheEntry entry, boolean cleanOthers) {
        if (entry != null) {
            ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> cache = this.getAPTCache(absPath, cleanOthers ? Boolean.TRUE : Boolean.FALSE);
            APTIncludeHandler.State key = APTFileCacheManager.getKey(preprocHandler);
            cache.put(key, APTFileCacheEntry.toSerial(entry));
        }
    }

    public void invalidate(CharSequence absPath) {
        ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> fileEntry = this.getAPTCache(absPath, null);
        if (fileEntry != null) {
            fileEntry.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateAll() {
        Class<APTFileCacheManager> clazz = APTFileCacheManager.class;
        synchronized (APTFileCacheManager.class) {
            for (APTFileCacheManager manager : managers.values()) {
                manager.file2AptCacheRef.clear();
            }
            managers.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void close() {
        APTFileCacheManager.invalidateAll();
    }

    private static APTIncludeHandler.State getKey(APTPreprocHandler preprocHandler) {
        return preprocHandler.getIncludeHandler().getState();
    }

    private final class Lock {
        private Lock() {
        }
    }
}

