/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.modules.dlight.core.stack.api.Function;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;

final class CallStackTreeModel
extends DefaultTreeModel {
    private SourceFileInfoDataProvider dataProvider;
    private final DefaultMutableTreeNode rootNode;

    CallStackTreeModel(SourceFileInfoDataProvider dataProvider) {
        this(dataProvider, new DefaultMutableTreeNode());
    }

    private CallStackTreeModel(SourceFileInfoDataProvider dataProvider, DefaultMutableTreeNode root) {
        super(root);
        this.rootNode = root;
        this.dataProvider = dataProvider;
    }

    void clear() {
        this.rootNode.removeAllChildren();
        this.rootNode.setUserObject(null);
    }

    void addStack(List<FunctionCall> stack) {
        ArrayList<FunctionCall> functionCalls = new ArrayList<FunctionCall>();
        functionCalls.addAll(stack);
        this.add(this.rootNode, functionCalls);
    }

    private DefaultMutableTreeNode createNode(List<FunctionCall> stack) {
        DefaultMutableTreeNode result;
        DefaultMutableTreeNode parent = result = new DefaultMutableTreeNode(stack.get(0));
        for (int i = 1; i < stack.size(); ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(stack.get(i));
            parent.add(node);
            parent = node;
        }
        return result;
    }

    private void add(DefaultMutableTreeNode root, List<FunctionCall> functionCalls) {
        if (functionCalls.isEmpty()) {
            return;
        }
        FunctionCall rootCall = functionCalls.get(0);
        Function function = rootCall.getFunction();
        boolean notFound = true;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            FunctionCall childFunctionCall = (FunctionCall)child.getUserObject();
            if (childFunctionCall == null) {
                return;
            }
            Function childFunction = childFunctionCall.getFunction();
            long offset = childFunctionCall.getOffset();
            if (!function.equals(childFunction) || offset != rootCall.getOffset()) continue;
            FunctionCall[] stack = functionCalls.toArray(new FunctionCall[0]);
            FunctionCall[] resultStack = new FunctionCall[stack.length - 1];
            System.arraycopy(stack, 1, resultStack, 0, stack.length - 1);
            notFound = false;
            this.add(child, Arrays.asList(resultStack));
        }
        if (notFound) {
            root.add(this.createNode(functionCalls));
        }
    }

    List<FunctionCall> getRootChildren() {
        ArrayList<FunctionCall> result = new ArrayList<FunctionCall>();
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            FunctionCall call = (FunctionCall)((DefaultMutableTreeNode)this.rootNode.getChildAt(i)).getUserObject();
            if (call == null) continue;
            result.add(call);
        }
        return result;
    }

    List<FunctionCall> getCallers(FunctionCall call) {
        DefaultMutableTreeNode node = this.findByFunctionCall(this.rootNode, call);
        ArrayList<FunctionCall> result = new ArrayList<FunctionCall>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            FunctionCall fCall = (FunctionCall)((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject();
            if (fCall == null) continue;
            result.add(fCall);
        }
        return result;
    }

    DefaultMutableTreeNode findByFunctionCall(DefaultMutableTreeNode node, FunctionCall call) {
        FunctionCall fCall = (FunctionCall)node.getUserObject();
        if (fCall != null) {
            Function childFunction = fCall.getFunction();
            long offset = fCall.getOffset();
            if (call.getFunction().equals(childFunction) && offset == call.getOffset()) {
                return node;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode result = this.findByFunctionCall(child, call);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(FunctionCall call) {
        return this.dataProvider.getSourceFileInfo(call);
    }

    SourceFileInfoDataProvider getSourceFileInfoProvider() {
        return this.dataProvider;
    }

    void setSourceFileInfoProvider(SourceFileInfoDataProvider p) {
        this.dataProvider = p;
    }
}

