/*
 * Decompiled with CFR 0.152.
 */
package org.h2.compress;

import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.h2.compress.Compressor;
import org.h2.message.Message;

public class CompressDeflate
implements Compressor {
    private int level = -1;
    private int strategy = 0;

    public void setOptions(String string) throws SQLException {
        if (string == null) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                if ("level".equals(string2) || "l".equals(string2)) {
                    this.level = Integer.parseInt(stringTokenizer.nextToken());
                } else if ("strategy".equals(string2) || "s".equals(string2)) {
                    this.strategy = Integer.parseInt(stringTokenizer.nextToken());
                }
                Deflater deflater = new Deflater(this.level);
                deflater.setStrategy(this.strategy);
            }
        }
        catch (Exception exception) {
            throw Message.getSQLException(90102, string);
        }
    }

    public int compress(byte[] byArray, int n, byte[] byArray2, int n2) {
        Deflater deflater = new Deflater(this.level);
        deflater.setStrategy(this.strategy);
        deflater.setInput(byArray, 0, n);
        deflater.finish();
        int n3 = deflater.deflate(byArray2, n2, byArray2.length - n2);
        return n3;
    }

    public int getAlgorithm() {
        return 2;
    }

    public void expand(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws SQLException {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray, n, n2);
        inflater.finished();
        try {
            inflater.inflate(byArray2, n3, n4);
        }
        catch (DataFormatException dataFormatException) {
            throw Message.getSQLException(90104, null, dataFormatException);
        }
        inflater.end();
    }
}

