/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.fulltext.IndexInfo;
import org.h2.util.ObjectUtils;

class FullTextSettings {
    private static HashMap settings = new HashMap();
    private HashSet ignoreList = new HashSet();
    private HashMap words = new HashMap();
    private HashMap indexes = new HashMap();
    private PreparedStatement prepSelectMapByWordId;
    private PreparedStatement prepSelectRowById;

    private FullTextSettings() {
    }

    HashSet getIgnoreList() {
        return this.ignoreList;
    }

    HashMap getWordList() {
        return this.words;
    }

    IndexInfo getIndexInfo(long l) {
        return (IndexInfo)this.indexes.get(ObjectUtils.getLong(l));
    }

    void addIndexInfo(IndexInfo indexInfo) {
        this.indexes.put(ObjectUtils.getLong(indexInfo.id), indexInfo);
    }

    String convertWord(String string) {
        if (this.ignoreList.contains(string = string.toUpperCase())) {
            return null;
        }
        return string;
    }

    static FullTextSettings getInstance(Connection connection) throws SQLException {
        String string = FullTextSettings.getIndexPath(connection);
        FullTextSettings fullTextSettings = (FullTextSettings)settings.get(string);
        if (fullTextSettings == null) {
            fullTextSettings = new FullTextSettings();
            settings.put(string, fullTextSettings);
        }
        return fullTextSettings;
    }

    private static String getIndexPath(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("CALL IFNULL(DATABASE_PATH(), 'MEM:' || DATABASE())");
        resultSet.next();
        String string = resultSet.getString(1);
        if ("MEM:UNNAMED".equals(string)) {
            throw new SQLException("FULLTEXT", "Fulltext search for private (unnamed) in-memory databases is not supported.");
        }
        resultSet.close();
        return string;
    }

    PreparedStatement getPrepSelectMapByWordId() {
        return this.prepSelectMapByWordId;
    }

    void setPrepSelectMapByWordId(PreparedStatement preparedStatement) {
        this.prepSelectMapByWordId = preparedStatement;
    }

    PreparedStatement getPrepSelectRowById() {
        return this.prepSelectRowById;
    }

    void setPrepSelectRowById(PreparedStatement preparedStatement) {
        this.prepSelectRowById = preparedStatement;
    }
}

